/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;

public class NodeVector
implements Serializable,
Cloneable {
    private int m_blocksize;
    private int[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeVector(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = 0;
    }

    public void RemoveAllNoClear() {
        if (this.m_map == null) {
            return;
        }
        this.m_firstFree = 0;
    }

    public void addElement(int value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] newMap = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeVector nodes) {
        int nNodes = nodes.size();
        if (this.m_map == null) {
            this.m_mapSize = nNodes + this.m_blocksize;
            this.m_map = new int[this.m_mapSize];
        } else if (this.m_firstFree + nNodes >= this.m_mapSize) {
            this.m_mapSize += nNodes + this.m_blocksize;
            int[] newMap = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + nNodes);
            this.m_map = newMap;
        }
        System.arraycopy(nodes.m_map, 0, this.m_map, this.m_firstFree, nNodes);
        this.m_firstFree += nNodes;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeVector clone = (NodeVector)super.clone();
        if (this.m_map != null && this.m_map == clone.m_map) {
            clone.m_map = new int[this.m_map.length];
            System.arraycopy(this.m_map, 0, clone.m_map, 0, this.m_map.length);
        }
        return clone;
    }

    public boolean contains(int s2) {
        if (this.m_map == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            int node = this.m_map[i2];
            if (node == s2) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public int elementAt(int i2) {
        if (this.m_map == null) {
            return -1;
        }
        return this.m_map[i2];
    }

    public int indexOf(int elem) {
        if (this.m_map == null) {
            return -1;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            int node = this.m_map[i2];
            if (node == elem) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int indexOf(int elem, int index) {
        if (this.m_map == null) {
            return -1;
        }
        int i2 = index;
        while (i2 < this.m_firstFree) {
            int node = this.m_map[i2];
            if (node == elem) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void insertElementAt(int value, int at2) {
        if (this.m_map == null) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] newMap = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at2, this.m_map, at2 + 1, this.m_firstFree - at2);
        }
        this.m_map[at2] = value;
        ++this.m_firstFree;
    }

    public void insertInOrder(int value) {
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            if (value < this.m_map[i2]) {
                this.insertElementAt(value, i2);
                return;
            }
            ++i2;
        }
        this.addElement(value);
    }

    public final int peepOrNull() {
        return this.m_map != null && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : -1;
    }

    public final int peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final int peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final int pop() {
        --this.m_firstFree;
        int n2 = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = -1;
        return n2;
    }

    public final int popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
        return this.m_firstFree == 0 ? -1 : this.m_map[this.m_firstFree - 1];
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = -1;
        this.m_map[this.m_firstFree + 1] = -1;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
    }

    public final void push(int value) {
        int ff2 = this.m_firstFree;
        if (ff2 + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] newMap = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, ff2 + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[ff2] = value;
        this.m_firstFree = ++ff2;
    }

    public final void pushPair(int v1, int v2) {
        if (this.m_map == null) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] newMap = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = v1;
        this.m_map[this.m_firstFree + 1] = v2;
        this.m_firstFree += 2;
    }

    public void removeAllElements() {
        if (this.m_map == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            this.m_map[i2] = -1;
            ++i2;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(int s2) {
        if (this.m_map == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            int node = this.m_map[i2];
            if (node == s2) {
                if (i2 > this.m_firstFree) {
                    System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
                } else {
                    this.m_map[i2] = -1;
                }
                --this.m_firstFree;
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void removeElementAt(int i2) {
        if (this.m_map == null) {
            return;
        }
        if (i2 > this.m_firstFree) {
            System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
        } else {
            this.m_map[i2] = -1;
        }
    }

    public void setElementAt(int node, int index) {
        if (this.m_map == null) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[index] = node;
    }

    public final void setTail(int n2) {
        this.m_map[this.m_firstFree - 1] = n2;
    }

    public final void setTailSub1(int n2) {
        this.m_map[this.m_firstFree - 2] = n2;
    }

    public int size() {
        return this.m_firstFree;
    }

    public void sort() throws Exception {
        this.sort(this.m_map, 0, this.m_firstFree - 1);
    }

    /*
     * Unable to fully structure code
     */
    public void sort(int[] a, int lo0, int hi0) throws Exception {
        lo = lo0;
        hi = hi0;
        if (lo >= hi) {
            return;
        }
        if (lo == hi - 1) {
            if (a[lo] > a[hi]) {
                T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
            }
            return;
        }
        pivot = a[(lo + hi) / 2];
        a[(lo + hi) / 2] = a[hi];
        a[hi] = pivot;
        ** GOTO lbl25
        {
            ++lo;
            do {
                if (a[lo] <= pivot && lo < hi) continue block0;
                while (pivot <= a[hi] && lo < hi) {
                    --hi;
                }
                if (lo >= hi) continue;
                T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
lbl25:
                // 3 sources

            } while (lo < hi);
        }
        a[hi0] = a[hi];
        a[hi] = pivot;
        this.sort(a, lo0, lo - 1);
        this.sort(a, hi + 1, hi0);
    }
}

