/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class StringToIntTable {
    private int m_blocksize;
    private String[] m_map;
    private int[] m_values;
    private int m_firstFree = 0;
    private int m_mapSize;

    public StringToIntTable() {
        this.m_mapSize = this.m_blocksize = 8;
        this.m_map = new String[this.m_blocksize];
        this.m_values = new int[this.m_blocksize];
    }

    public StringToIntTable(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = blocksize;
        this.m_map = new String[blocksize];
        this.m_values = new int[this.m_blocksize];
    }

    public final boolean contains(String key) {
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            if (this.m_map[i2].equals(key)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public final int get(String key) {
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            if (this.m_map[i2].equals(key)) {
                return this.m_values[i2];
            }
            ++i2;
        }
        return -10000;
    }

    public final int getIgnoreCase(String key) {
        if (key == null) {
            return -10000;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            if (this.m_map[i2].equalsIgnoreCase(key)) {
                return this.m_values[i2];
            }
            ++i2;
        }
        return -10000;
    }

    public final int getLength() {
        return this.m_firstFree;
    }

    public final void put(String key, int value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            String[] newMap = new String[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
            int[] newValues = new int[this.m_mapSize];
            System.arraycopy(this.m_values, 0, newValues, 0, this.m_firstFree + 1);
            this.m_values = newValues;
        }
        this.m_map[this.m_firstFree] = key;
        this.m_values[this.m_firstFree] = value;
        ++this.m_firstFree;
    }
}

