/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.NSInfo;
import org.apache.xml.utils.StringBufferPool;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMHelper {
    Hashtable m_NSInfos = new Hashtable();
    protected static final NSInfo m_NSInfoUnProcWithXMLNS = new NSInfo(false, true);
    protected static final NSInfo m_NSInfoUnProcWithoutXMLNS = new NSInfo(false, false);
    protected static final NSInfo m_NSInfoUnProcNoAncestorXMLNS = new NSInfo(false, false, 2);
    protected static final NSInfo m_NSInfoNullWithXMLNS = new NSInfo(true, true);
    protected static final NSInfo m_NSInfoNullWithoutXMLNS = new NSInfo(true, false);
    protected static final NSInfo m_NSInfoNullNoAncestorXMLNS = new NSInfo(true, false, 2);
    protected Vector m_candidateNoAncestorXMLNS = new Vector();
    protected Document m_DOMFactory = null;

    public static Document createDocument() {
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(true);
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document outNode = docBuilder.newDocument();
            return outNode;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(54, null));
        }
    }

    public Document getDOMFactory() {
        if (this.m_DOMFactory == null) {
            this.m_DOMFactory = DOMHelper.createDocument();
        }
        return this.m_DOMFactory;
    }

    public Element getElementByID(String id, Document doc) {
        return null;
    }

    public String getExpandedAttributeName(Attr attr) {
        String namespace = this.getNamespaceOfNode(attr);
        return namespace != null ? String.valueOf(namespace) + ":" + this.getLocalNameOfNode(attr) : this.getLocalNameOfNode(attr);
    }

    public String getExpandedElementName(Element elem) {
        String namespace = this.getNamespaceOfNode(elem);
        return namespace != null ? String.valueOf(namespace) + ":" + this.getLocalNameOfNode(elem) : this.getLocalNameOfNode(elem);
    }

    public short getLevel(Node n2) {
        short level = 1;
        while ((n2 = DOMHelper.getParentOfNode(n2)) != null) {
            level = (short)(level + 1);
        }
        return level;
    }

    public String getLocalNameOfNode(Node n2) {
        String qname = n2.getNodeName();
        int index = qname.indexOf(58);
        return index < 0 ? qname : qname.substring(index + 1);
    }

    public String getNamespaceForPrefix(String prefix, Element namespaceContext) {
        Node parent = namespaceContext;
        String namespace = null;
        if (prefix.equals("xml")) {
            namespace = "http://www.w3.org/XML/1998/namespace";
        } else if (prefix.equals("xmlns")) {
            namespace = "http://www.w3.org/2000/xmlns/";
        } else {
            short type;
            String declname = prefix == "" ? "xmlns" : "xmlns:" + prefix;
            while (parent != null && namespace == null && ((type = parent.getNodeType()) == 1 || type == 5)) {
                Attr attr;
                if (type == 1 && (attr = parent.getAttributeNode(declname)) != null) {
                    namespace = attr.getNodeValue();
                    break;
                }
                parent = DOMHelper.getParentOfNode(parent);
            }
        }
        return namespace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNamespaceOfNode(Node n2) {
        String prefix;
        boolean hasProcessedNS;
        NSInfo nsInfo;
        short ntype = n2.getNodeType();
        if (ntype != 2) {
            Object nsObj = this.m_NSInfos.get(n2);
            nsInfo = nsObj == null ? null : (NSInfo)nsObj;
            hasProcessedNS = nsInfo == null ? false : nsInfo.m_hasProcessedNS;
        } else {
            hasProcessedNS = false;
            nsInfo = null;
        }
        if (hasProcessedNS) {
            return nsInfo.m_namespace;
        }
        String namespaceOfPrefix = null;
        String nodeName = n2.getNodeName();
        int indexOfNSSep = nodeName.indexOf(58);
        if (ntype == 2) {
            if (indexOfNSSep <= 0) return namespaceOfPrefix;
            prefix = nodeName.substring(0, indexOfNSSep);
        } else {
            prefix = indexOfNSSep >= 0 ? nodeName.substring(0, indexOfNSSep) : "";
        }
        boolean ancestorsHaveXMLNS = false;
        boolean nHasXMLNS = false;
        if (prefix.equals("xml")) {
            namespaceOfPrefix = "http://www.w3.org/XML/1998/namespace";
        } else {
            int nCandidates;
            Node parent = n2;
            while (parent != null && namespaceOfPrefix == null) {
                if (nsInfo != null && nsInfo.m_ancestorHasXMLNSAttrs == 2) break;
                short parentType = parent.getNodeType();
                if (nsInfo == null || nsInfo.m_hasXMLNSAttrs) {
                    boolean elementHasXMLNS = false;
                    if (parentType == 1) {
                        NamedNodeMap nnm = parent.getAttributes();
                        int i2 = 0;
                        while (i2 < nnm.getLength()) {
                            Node attr = nnm.item(i2);
                            String aname = attr.getNodeName();
                            if (aname.charAt(0) == 'x') {
                                boolean isPrefix = aname.startsWith("xmlns:");
                                if (aname.equals("xmlns") || isPrefix) {
                                    String p2;
                                    if (n2 == parent) {
                                        nHasXMLNS = true;
                                    }
                                    elementHasXMLNS = true;
                                    ancestorsHaveXMLNS = true;
                                    String string = p2 = isPrefix ? aname.substring(6) : "";
                                    if (p2.equals(prefix)) {
                                        namespaceOfPrefix = attr.getNodeValue();
                                        break;
                                    }
                                }
                            }
                            ++i2;
                        }
                    }
                    if (parentType != 2 && nsInfo == null && n2 != parent) {
                        nsInfo = elementHasXMLNS ? m_NSInfoUnProcWithXMLNS : m_NSInfoUnProcWithoutXMLNS;
                        this.m_NSInfos.put(parent, nsInfo);
                    }
                }
                if (parentType == 2) {
                    parent = DOMHelper.getParentOfNode(parent);
                } else {
                    this.m_candidateNoAncestorXMLNS.addElement(parent);
                    this.m_candidateNoAncestorXMLNS.addElement(nsInfo);
                    parent = parent.getParentNode();
                }
                if (parent == null) continue;
                Object nsObj = this.m_NSInfos.get(parent);
                NSInfo nSInfo = nsInfo = nsObj == null ? null : (NSInfo)nsObj;
            }
            if ((nCandidates = this.m_candidateNoAncestorXMLNS.size()) > 0) {
                if (!ancestorsHaveXMLNS && parent == null) {
                    int i3 = 0;
                    while (i3 < nCandidates) {
                        Object candidateInfo = this.m_candidateNoAncestorXMLNS.elementAt(i3 + 1);
                        if (candidateInfo == m_NSInfoUnProcWithoutXMLNS) {
                            this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(i3), m_NSInfoUnProcNoAncestorXMLNS);
                        } else if (candidateInfo == m_NSInfoNullWithoutXMLNS) {
                            this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(i3), m_NSInfoNullNoAncestorXMLNS);
                        }
                        i3 += 2;
                    }
                }
                this.m_candidateNoAncestorXMLNS.removeAllElements();
            }
        }
        if (ntype == 2) return namespaceOfPrefix;
        if (namespaceOfPrefix == null) {
            if (ancestorsHaveXMLNS) {
                if (nHasXMLNS) {
                    this.m_NSInfos.put(n2, m_NSInfoNullWithXMLNS);
                    return namespaceOfPrefix;
                } else {
                    this.m_NSInfos.put(n2, m_NSInfoNullWithoutXMLNS);
                }
                return namespaceOfPrefix;
            } else {
                this.m_NSInfos.put(n2, m_NSInfoNullNoAncestorXMLNS);
            }
            return namespaceOfPrefix;
        } else {
            this.m_NSInfos.put(n2, new NSInfo(namespaceOfPrefix, nHasXMLNS));
        }
        return namespaceOfPrefix;
    }

    public static String getNodeData(Node node) {
        String s2;
        FastStringBuffer buf = StringBufferPool.get();
        try {
            DOMHelper.getNodeData(node, buf);
            s2 = buf.length() > 0 ? buf.toString() : "";
        }
        finally {
            Object var4_3 = null;
            StringBufferPool.free(buf);
        }
        return s2;
    }

    public static void getNodeData(Node node, FastStringBuffer buf) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                Node child = node.getFirstChild();
                while (child != null) {
                    DOMHelper.getNodeData(child, buf);
                    child = child.getNextSibling();
                }
                break;
            }
            case 3: 
            case 4: {
                buf.append(node.getNodeValue());
                break;
            }
            case 2: {
                buf.append(node.getNodeValue());
                break;
            }
        }
    }

    public static Node getParentOfNode(Node node) throws RuntimeException {
        Node parent;
        short nodeType = node.getNodeType();
        if (nodeType == 2) {
            Document doc = node.getOwnerDocument();
            DOMImplementation impl = doc.getImplementation();
            if (impl != null && impl.hasFeature("Core", "2.0")) {
                Element parent2 = ((Attr)node).getOwnerElement();
                return parent2;
            }
            Element rootElem = doc.getDocumentElement();
            if (rootElem == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(56, null));
            }
            parent = DOMHelper.locateAttrParent(rootElem, node);
        } else {
            parent = node.getParentNode();
        }
        return parent;
    }

    public Node getRoot(Node node) {
        Node root = null;
        while (node != null) {
            root = node;
            node = DOMHelper.getParentOfNode(node);
        }
        return root;
    }

    public Node getRootNode(Node n2) {
        short nt = n2.getNodeType();
        return nt == 9 || nt == 11 ? n2 : n2.getOwnerDocument();
    }

    public String getUniqueID(Node node) {
        return "N" + Integer.toHexString(node.hashCode()).toUpperCase();
    }

    public String getUnparsedEntityURI(String name, Document doc) {
        String url = "";
        DocumentType doctype = doc.getDoctype();
        if (doctype != null) {
            NamedNodeMap entities = doctype.getEntities();
            if (entities == null) {
                return url;
            }
            Entity entity = (Entity)entities.getNamedItem(name);
            if (entity == null) {
                return url;
            }
            String notationName = entity.getNotationName();
            if (notationName != null && (url = entity.getSystemId()) == null) {
                url = entity.getPublicId();
            }
        }
        return url;
    }

    public boolean isIgnorableWhitespace(Text node) {
        boolean isIgnorable = false;
        return isIgnorable;
    }

    public boolean isNamespaceNode(Node n2) {
        if (n2.getNodeType() == 2) {
            String attrName = n2.getNodeName();
            return attrName.startsWith("xmlns:") || attrName.equals("xmlns");
        }
        return false;
    }

    public static boolean isNodeAfter(Node node1, Node node2) {
        Node parent2;
        if (node1 == node2) {
            return true;
        }
        boolean isNodeAfter = true;
        Node parent1 = DOMHelper.getParentOfNode(node1);
        if (parent1 == (parent2 = DOMHelper.getParentOfNode(node2))) {
            if (parent1 != null) {
                isNodeAfter = DOMHelper.isNodeAfterSibling(parent1, node1, node2);
            }
        } else {
            int i2;
            int adjust;
            int nParents1 = 2;
            int nParents2 = 2;
            while (parent1 != null) {
                ++nParents1;
                parent1 = DOMHelper.getParentOfNode(parent1);
            }
            while (parent2 != null) {
                ++nParents2;
                parent2 = DOMHelper.getParentOfNode(parent2);
            }
            Node startNode1 = node1;
            Node startNode2 = node2;
            if (nParents1 < nParents2) {
                adjust = nParents2 - nParents1;
                i2 = 0;
                while (i2 < adjust) {
                    startNode2 = DOMHelper.getParentOfNode(startNode2);
                    ++i2;
                }
            } else if (nParents1 > nParents2) {
                adjust = nParents1 - nParents2;
                i2 = 0;
                while (i2 < adjust) {
                    startNode1 = DOMHelper.getParentOfNode(startNode1);
                    ++i2;
                }
            }
            Node prevChild1 = null;
            Node prevChild2 = null;
            while (startNode1 != null) {
                if (startNode1 == startNode2) {
                    if (prevChild1 == null) {
                        isNodeAfter = nParents1 < nParents2;
                        break;
                    }
                    isNodeAfter = DOMHelper.isNodeAfterSibling(startNode1, prevChild1, prevChild2);
                    break;
                }
                prevChild1 = startNode1;
                startNode1 = DOMHelper.getParentOfNode(startNode1);
                prevChild2 = startNode2;
                startNode2 = DOMHelper.getParentOfNode(startNode2);
            }
        }
        return isNodeAfter;
    }

    private static boolean isNodeAfterSibling(Node parent, Node child1, Node child2) {
        boolean isNodeAfterSibling = false;
        short child1type = child1.getNodeType();
        short child2type = child2.getNodeType();
        if (child1type != 2 && child2type == 2) {
            isNodeAfterSibling = false;
        } else if (child1type == 2 && child2type != 2) {
            isNodeAfterSibling = true;
        } else if (child1type == 2) {
            NamedNodeMap children = parent.getAttributes();
            int nNodes = children.getLength();
            boolean found1 = false;
            boolean found2 = false;
            int i2 = 0;
            while (i2 < nNodes) {
                Node child = children.item(i2);
                if (child1 == child) {
                    if (found2) {
                        isNodeAfterSibling = false;
                        break;
                    }
                    found1 = true;
                } else if (child2 == child) {
                    if (found1) {
                        isNodeAfterSibling = true;
                        break;
                    }
                    found2 = true;
                }
                ++i2;
            }
        } else {
            Node child = parent.getFirstChild();
            boolean found1 = false;
            boolean found2 = false;
            while (child != null) {
                if (child1 == child) {
                    if (found2) {
                        isNodeAfterSibling = false;
                        break;
                    }
                    found1 = true;
                } else if (child2 == child) {
                    if (found1) {
                        isNodeAfterSibling = true;
                        break;
                    }
                    found2 = true;
                }
                child = child.getNextSibling();
            }
        }
        return isNodeAfterSibling;
    }

    private static Node locateAttrParent(Element elem, Node attr) {
        Node parent = null;
        Attr check = elem.getAttributeNode(attr.getNodeName());
        if (check == attr) {
            parent = elem;
        }
        if (parent == null) {
            Node node = elem.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && (parent = DOMHelper.locateAttrParent((Element)node, attr)) != null) break;
                node = node.getNextSibling();
            }
        }
        return parent;
    }

    public void setDOMFactory(Document domFactory) {
        this.m_DOMFactory = domFactory;
    }

    public boolean shouldStripSourceNode(Node textNode) throws TransformerException {
        return false;
    }
}

