/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    private transient int m_last = 0;
    private int m_blocksize;
    Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeSet() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeSet(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = 0;
    }

    public NodeSet(NodeSet nodelist) {
        this(32);
        this.addNodes((NodeIterator)nodelist);
    }

    public NodeSet(Node node) {
        this(32);
        this.addNode(node);
    }

    public NodeSet(NodeList nodelist) {
        this(32);
        this.addNodes(nodelist);
    }

    public NodeSet(NodeIterator ni) {
        this(32);
        this.addNodes(ni);
    }

    public void addElement(Node value) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] newMap = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public void addNode(Node n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.addElement(n2);
    }

    public int addNodeInDocOrder(Node node, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        return this.addNodeInDocOrder(node, true, support);
    }

    public int addNodeInDocOrder(Node node, boolean test, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        int insertIndex = -1;
        if (test) {
            int size = this.size();
            int i2 = size - 1;
            while (i2 >= 0) {
                Node child = this.elementAt(i2);
                if (child == node) {
                    i2 = -2;
                    break;
                }
                if (!DOM2Helper.isNodeAfter(node, child)) break;
                --i2;
            }
            if (i2 != -2) {
                insertIndex = i2 + 1;
                this.insertElementAt(node, insertIndex);
            }
        } else {
            insertIndex = this.size();
            boolean foundit = false;
            int i3 = 0;
            while (i3 < insertIndex) {
                if (this.item(i3).equals(node)) {
                    foundit = true;
                    break;
                }
                ++i3;
            }
            if (!foundit) {
                this.addElement(node);
            }
        }
        return insertIndex;
    }

    public void addNodes(NodeSet ns) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.addNodes((NodeIterator)ns);
    }

    public void addNodes(NodeList nodelist) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (nodelist != null) {
            int nChildren = nodelist.getLength();
            int i2 = 0;
            while (i2 < nChildren) {
                Node obj = nodelist.item(i2);
                if (obj != null) {
                    this.addElement(obj);
                }
                ++i2;
            }
        }
    }

    public void addNodes(NodeIterator iterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (iterator != null) {
            Node obj;
            while ((obj = iterator.nextNode()) != null) {
                this.addElement(obj);
            }
        }
    }

    private boolean addNodesInDocOrder(int start, int end, int testIndex, NodeList nodelist, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        boolean foundit = false;
        Node node = nodelist.item(testIndex);
        int i2 = end;
        while (i2 >= start) {
            Node child = this.elementAt(i2);
            if (child == node) {
                i2 = -2;
                break;
            }
            if (!DOM2Helper.isNodeAfter(node, child)) {
                boolean foundPrev;
                this.insertElementAt(node, i2 + 1);
                if (--testIndex <= 0 || (foundPrev = this.addNodesInDocOrder(0, i2, testIndex, nodelist, support))) break;
                this.addNodesInDocOrder(i2, this.size() - 1, testIndex, nodelist, support);
                break;
            }
            --i2;
        }
        if (i2 == -1) {
            this.insertElementAt(node, 0);
        }
        return foundit;
    }

    public void addNodesInDocOrder(NodeList nodelist, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        int nChildren = nodelist.getLength();
        int i2 = 0;
        while (i2 < nChildren) {
            Node node = nodelist.item(i2);
            if (node != null) {
                this.addNodeInDocOrder(node, support);
            }
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(NodeIterator iterator, XPathContext support) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder(node, support);
lbl5:
            // 2 sources

            ** while ((node = iterator.nextNode()) != null)
        }
lbl6:
        // 1 sources

    }

    public void appendNodes(NodeSet nodes) {
        int nNodes = nodes.size();
        if (this.m_map == null) {
            this.m_mapSize = nNodes + this.m_blocksize;
            this.m_map = new Node[this.m_mapSize];
        } else if (this.m_firstFree + nNodes >= this.m_mapSize) {
            this.m_mapSize += nNodes + this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + nNodes);
            this.m_map = newMap;
        }
        System.arraycopy(nodes.m_map, 0, this.m_map, this.m_firstFree, nNodes);
        this.m_firstFree += nNodes;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)super.clone();
        if (this.m_map != null && this.m_map == clone.m_map) {
            clone.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, clone.m_map, 0, this.m_map.length);
        }
        return clone;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)this.clone();
        clone.reset();
        return clone;
    }

    public boolean contains(Node s2) {
        this.runTo(-1);
        if (this.m_map == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            Node node = this.m_map[i2];
            if (node != null && node.equals(s2)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void detach() {
    }

    public Node elementAt(int i2) {
        if (this.m_map == null) {
            return null;
        }
        return this.m_map[i2];
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        int saved = this.m_next;
        Node n2 = this.m_next < this.m_firstFree ? this.elementAt(this.m_next) : null;
        this.m_next = saved;
        return n2;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public Node getRoot() {
        return null;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public int getWhatToShow() {
        return -17;
    }

    public int indexOf(Node elem) {
        this.runTo(-1);
        if (this.m_map == null) {
            return -1;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            Node node = this.m_map[i2];
            if (node != null && node.equals(elem)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int indexOf(Node elem, int index) {
        this.runTo(-1);
        if (this.m_map == null) {
            return -1;
        }
        int i2 = index;
        while (i2 < this.m_firstFree) {
            Node node = this.m_map[i2];
            if (node != null && node.equals(elem)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void insertElementAt(Node value, int at2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at2, this.m_map, at2 + 1, this.m_firstFree - at2);
        }
        this.m_map[at2] = value;
        ++this.m_firstFree;
    }

    public void insertNode(Node n2, int pos) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.insertElementAt(n2, pos);
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public Node item(int index) {
        this.runTo(index);
        return this.elementAt(index);
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node next = this.elementAt(this.m_next);
            ++this.m_next;
            return next;
        }
        return null;
    }

    public final Node peepOrNull() {
        return this.m_map != null && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : null;
    }

    public final Node peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final Node peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final Node pop() {
        --this.m_firstFree;
        Node n2 = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return n2;
    }

    public final Node popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
        return this.m_firstFree == 0 ? null : this.m_map[this.m_firstFree - 1];
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = null;
        this.m_map[this.m_firstFree + 1] = null;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public final void push(Node value) {
        int ff2 = this.m_firstFree;
        if (ff2 + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] newMap = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, ff2 + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[ff2] = value;
        this.m_firstFree = ++ff2;
    }

    public final void pushPair(Node v1, Node v2) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = v1;
        this.m_map[this.m_firstFree + 1] = v2;
        this.m_firstFree += 2;
    }

    public void removeAllElements() {
        if (this.m_map == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            this.m_map[i2] = null;
            ++i2;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(Node s2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_map == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            Node node = this.m_map[i2];
            if (node != null && node.equals(s2)) {
                if (i2 > this.m_firstFree) {
                    System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
                } else {
                    this.m_map[i2] = null;
                }
                --this.m_firstFree;
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void removeElementAt(int i2) {
        if (this.m_map == null) {
            return;
        }
        if (i2 > this.m_firstFree) {
            System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
        } else {
            this.m_map[i2] = null;
        }
    }

    public void removeNode(Node n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        this.removeElement(n2);
    }

    public void reset() {
        this.m_next = 0;
    }

    public void runTo(int index) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    public void setCurrentPos(int i2) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = i2;
    }

    public void setElementAt(Node node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(72, null));
        }
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[index] = node;
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public void setShouldCacheNodes(boolean b10) {
        if (!this.isFresh()) {
            throw new RuntimeException("Can not call setShouldCacheNodes after nextNode has been called!");
        }
        this.m_cacheNodes = b10;
        this.m_mutable = true;
    }

    public final void setTail(Node n2) {
        this.m_map[this.m_firstFree - 1] = n2;
    }

    public final void setTailSub1(Node n2) {
        this.m_map[this.m_firstFree - 2] = n2;
    }

    public int size() {
        return this.m_firstFree;
    }
}

