/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.SourceTree;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTreeManager {
    private Vector m_sourceTree = new Vector();
    URIResolver m_uriResolver;

    public String findURIFromDoc(int owner) {
        int n2 = this.m_sourceTree.size();
        int i2 = 0;
        while (i2 < n2) {
            SourceTree sTree = (SourceTree)this.m_sourceTree.elementAt(i2);
            if (owner == sTree.m_root) {
                return sTree.m_url;
            }
            ++i2;
        }
        return null;
    }

    public int getNode(Source source) {
        String url = source.getSystemId();
        if (url == null) {
            return -1;
        }
        int n2 = this.m_sourceTree.size();
        int i2 = 0;
        while (i2 < n2) {
            SourceTree sTree = (SourceTree)this.m_sourceTree.elementAt(i2);
            if (url.equals(sTree.m_url)) {
                return sTree.m_root;
            }
            ++i2;
        }
        return -1;
    }

    public int getSourceTree(String base, String urlString, SourceLocator locator, XPathContext xctxt) throws TransformerException {
        try {
            Source source = this.resolveURI(base, urlString, locator);
            return this.getSourceTree(source, locator, xctxt);
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), locator, ioe);
        }
    }

    public int getSourceTree(Source source, SourceLocator locator, XPathContext xctxt) throws TransformerException {
        int n2 = this.getNode(source);
        if (n2 != -1) {
            return n2;
        }
        n2 = this.parseToNode(source, locator, xctxt);
        if (n2 != -1) {
            this.putDocumentInCache(n2, source);
        }
        return n2;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public static XMLReader getXMLReader(Source inputSource, SourceLocator locator) throws TransformerException {
        try {
            boolean isUserReader;
            XMLReader reader = inputSource instanceof SAXSource ? ((SAXSource)inputSource).getXMLReader() : null;
            boolean bl2 = isUserReader = reader != null;
            if (reader == null) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex2) {
                    throw new SAXException(ex2);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
                if (reader == null) {
                    reader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {}
            return reader;
        }
        catch (SAXException se) {
            throw new TransformerException(se.getMessage(), locator, se);
        }
    }

    public int parseToNode(Source source, SourceLocator locator, XPathContext xctxt) throws TransformerException {
        try {
            Object xowner = xctxt.getOwnerObject();
            DTM dtm = xowner != null && xowner instanceof DTMWSFilter ? xctxt.getDTM(source, false, (DTMWSFilter)xowner, false, true) : xctxt.getDTM(source, false, null, false, true);
            return dtm.getDocument();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new TransformerException(e10.getMessage(), locator, e10);
        }
    }

    public void putDocumentInCache(int n2, Source source) {
        int cachedNode = this.getNode(source);
        if (cachedNode != -1) {
            if (cachedNode != n2) {
                throw new RuntimeException("Programmer's Error!  putDocumentInCache found reparse of doc: " + source.getSystemId());
            }
            return;
        }
        if (source.getSystemId() != null) {
            this.m_sourceTree.addElement(new SourceTree(n2, source.getSystemId()));
        }
    }

    public void reset() {
        this.m_sourceTree = new Vector();
    }

    public Source resolveURI(String base, String urlString, SourceLocator locator) throws TransformerException, IOException {
        Source source = null;
        if (this.m_uriResolver != null) {
            source = this.m_uriResolver.resolve(urlString, base);
        }
        if (source == null) {
            String uri = SystemIDResolver.getAbsoluteURI(urlString, base);
            source = new StreamSource(uri);
        }
        return source;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }
}

