/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XPath
implements Serializable {
    private Expression m_mainExp;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type) throws TransformerException {
        this(exprString, locator, prefixResolver, type, null);
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator);
        if (type == 0) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (type == 1) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage(71, new Object[]{Integer.toString(type)}));
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
    }

    public XPath(Expression expr) {
        this.setExpression(expr);
    }

    public void assertion(boolean b10, String msg) {
        if (!b10) {
            String fMsg = XSLMessages.createXPATHMessage(30, new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean bool(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        block8: {
            xctxt.pushNamespaceContext(namespaceContext);
            xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
            try {
                try {
                    var4_4 = this.m_mainExp.bool(xctxt);
                    var6_5 = null;
                    xctxt.popNamespaceContext();
                    xctxt.popCurrentNodeAndExpression();
                    return var4_4;
                }
                catch (TransformerException te) {
                    te.setLocator(this.getLocator());
                    el = xctxt.getErrorListener();
                    if (el != null) {
                        el.error(te);
                        break block8;
                    }
                    throw te;
                }
                catch (Exception e) {
                    ** while (e instanceof WrappedRuntimeException)
                }
lbl-1000:
                // 1 sources

                {
                    e = ((WrappedRuntimeException)e).getException();
                    continue;
                }
lbl22:
                // 1 sources

                msg = e.getMessage();
                msg = msg == null || msg.length() == 0 ? "Unknown error in XPath" : msg;
                te = new TransformerException(msg, this.getLocator(), e);
                el = xctxt.getErrorListener();
                if (el != null) {
                    el.fatalError(te);
                    break block8;
                }
                throw te;
            }
            catch (Throwable var5_15) {
                var6_7 = null;
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
                throw var5_15;
            }
        }
        var6_6 = null;
        xctxt.popNamespaceContext();
        xctxt.popCurrentNodeAndExpression();
        return false;
    }

    public void error(XPathContext xctxt, int sourceNode, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (ehandler != null) {
            ehandler.fatalError(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        } else {
            SourceLocator slocator = xctxt.getSAXLocator();
            System.out.println(String.valueOf(fmsg) + "; file " + slocator.getSystemId() + "; line " + slocator.getLineNumber() + "; column " + slocator.getColumnNumber());
        }
    }

    /*
     * Unable to fully structure code
     */
    public XObject execute(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        xctxt.pushNamespaceContext(namespaceContext);
        xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
        xobj = null;
        try {
            block9: {
                try {
                    xobj = this.m_mainExp.execute(xctxt);
                    break block9;
                }
                catch (TransformerException te) {
                    te.setLocator(this.getLocator());
                    el = xctxt.getErrorListener();
                    if (el != null) {
                        el.error(te);
                        break block9;
                    }
                    throw te;
                }
                catch (Exception e) {
                    ** while (e instanceof WrappedRuntimeException)
                }
lbl-1000:
                // 1 sources

                {
                    e = ((WrappedRuntimeException)e).getException();
                    continue;
                }
lbl19:
                // 1 sources

                msg = e.getMessage();
                msg = msg == null || msg.length() == 0 ? "Unknown error in XPath" : msg;
                te = new TransformerException(msg, this.getLocator(), e);
                el = xctxt.getErrorListener();
                if (el != null) {
                    el.fatalError(te);
                } else {
                    throw te;
                }
            }
            var6_12 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
        }
        catch (Throwable var5_14) {
            var6_13 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            throw var5_14;
        }
        return xobj;
    }

    public XObject execute(XPathContext xctxt, Node contextNode, PrefixResolver namespaceContext) throws TransformerException {
        return this.execute(xctxt, xctxt.getDTMHandleFromNode(contextNode), namespaceContext);
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_mainExp.fixupVariables(vars, globalsSize);
    }

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp.m_slocator;
    }

    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.m_mainExp.execute(xctxt);
            double d10 = score.num();
            Object var6_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d10;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public void installFunction(String name, int funcIndex, Function func) {
        FunctionTable.installFunction(func, funcIndex);
    }

    public void setExpression(Expression exp) {
        this.m_mainExp = exp;
    }

    public void setLocator(SourceLocator l2) {
        this.m_mainExp.setSourceLocator(l2);
    }

    public void warn(XPathContext xctxt, int sourceNode, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (ehandler != null) {
            ehandler.warning(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        }
    }
}

