/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class ChildTestIterator
extends LocPathIterator {
    protected transient DTMAxisTraverser m_traverser;

    ChildTestIterator(DTMAxisTraverser traverser) {
        super((PrefixResolver)null);
        this.m_traverser = traverser;
    }

    ChildTestIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        int whatToShow = compiler.getWhatToShow(firstStepPos);
        if ((whatToShow & 0x1043) == 0 || whatToShow == -1) {
            this.initNodeTest(whatToShow);
        } else {
            this.initNodeTest(whatToShow, compiler.getStepNS(firstStepPos), compiler.getStepLocalName(firstStepPos));
        }
        this.initPredicateInfo(compiler, firstStepPos);
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        ChildTestIterator clone = (ChildTestIterator)super.cloneWithReset();
        clone.resetProximityPositions();
        return clone;
    }

    public int getAxis() {
        return 3;
    }

    protected int getNextNode() {
        this.m_lastFetched = this.m_lastFetched == -1 ? this.m_traverser.first(this.m_context) : this.m_traverser.next(this.m_context, this.m_lastFetched);
        return this.m_lastFetched;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int nextNode() {
        int n2;
        int savedStart;
        VariableStack vars;
        if (this.m_cachedNodes != null && this.m_next < this.m_cachedNodes.size()) {
            int next = this.m_cachedNodes.elementAt(this.m_next);
            this.incrementNextPosition();
            this.m_currentContextNode = next;
            return next;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        if (this.m_lastFetched == -1) {
            this.resetProximityPositions();
        }
        if (this.m_stackFrame != -1) {
            vars = this.m_execContext.getVarStack();
            savedStart = vars.getStackFrame();
            vars.setStackFrame(this.m_stackFrame);
        } else {
            vars = null;
            savedStart = 0;
        }
        try {
            int next;
            while ((next = this.getNextNode()) != -1 && this.acceptNode(next) != 1 && next != -1) {
            }
            if (next != -1) {
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(this.m_lastFetched);
                }
                ++this.m_next;
                int n3 = next;
                Object var6_7 = null;
                if (this.m_stackFrame == -1) return n3;
                vars.setStackFrame(savedStart);
                return n3;
            }
            this.m_foundLast = true;
            n2 = -1;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (this.m_stackFrame == -1) throw throwable;
            vars.setStackFrame(savedStart);
            throw throwable;
        }
        Object var6_8 = null;
        if (this.m_stackFrame == -1) return n2;
        vars.setStackFrame(savedStart);
        return n2;
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_traverser = this.m_cdtm.getAxisTraverser(3);
    }
}

