/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.patterns.NodeTest;

public class DescendantIterator
extends LocPathIterator {
    protected transient DTMAxisTraverser m_traverser;
    protected int m_axis;
    protected int m_extendedTypeID;

    public DescendantIterator() {
        super((PrefixResolver)null);
        this.m_axis = 18;
        int whatToShow = -1;
        this.initNodeTest(whatToShow);
    }

    DescendantIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
        int stepOp;
        int nextStepPos;
        int[] ops = compiler.getOpMap();
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        int stepType = ops[firstStepPos];
        boolean orSelf = stepType == 42;
        boolean fromRoot = false;
        if (stepType == 48) {
            orSelf = true;
        } else if (stepType == 50) {
            fromRoot = true;
            nextStepPos = compiler.getNextStepPos(firstStepPos);
            if (ops[nextStepPos] == 42) {
                orSelf = true;
            }
        }
        nextStepPos = firstStepPos;
        while ((nextStepPos = compiler.getNextStepPos(nextStepPos)) > 0 && (stepOp = compiler.getOp(nextStepPos)) != -1) {
            firstStepPos = nextStepPos;
        }
        if ((analysis & 0x10000) != 0) {
            orSelf = false;
        }
        this.m_axis = fromRoot ? (orSelf ? 18 : 17) : (orSelf ? 5 : 4);
        int whatToShow = compiler.getWhatToShow(firstStepPos);
        if ((whatToShow & 0x43) == 0 || whatToShow == -1) {
            this.initNodeTest(whatToShow);
        } else {
            this.initNodeTest(whatToShow, compiler.getStepNS(firstStepPos), compiler.getStepLocalName(firstStepPos));
        }
        this.initPredicateInfo(compiler, firstStepPos);
    }

    public int asNode(XPathContext xctxt) throws TransformerException {
        if (this.getPredicateCount() > 0) {
            return super.asNode(xctxt);
        }
        int current = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(current);
        DTMAxisTraverser traverser = dtm.getAxisTraverser(this.m_axis);
        String localName = this.getLocalName();
        String namespace = this.getNamespace();
        int what = this.m_whatToShow;
        if (what == -1 || localName == "*" || namespace == "*") {
            return traverser.first(current);
        }
        int type = NodeTest.getNodeTypeTest(what);
        int extendedType = dtm.getExpandedTypeID(namespace, localName, type);
        return traverser.first(current, extendedType);
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        DescendantIterator clone = (DescendantIterator)super.cloneWithReset();
        clone.resetProximityPositions();
        return clone;
    }

    public void detach() {
        this.m_traverser = null;
        this.m_extendedTypeID = 0;
        super.detach();
    }

    public int getAxis() {
        return this.m_axis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int nextNode() {
        int n2;
        int savedStart;
        VariableStack vars;
        if (this.m_cachedNodes != null && this.m_next < this.m_cachedNodes.size()) {
            int next = this.m_cachedNodes.elementAt(this.m_next);
            this.incrementNextPosition();
            this.m_currentContextNode = next;
            return next;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        if (this.m_lastFetched == -1) {
            this.resetProximityPositions();
        }
        if (this.m_stackFrame != -1) {
            vars = this.m_execContext.getVarStack();
            savedStart = vars.getStackFrame();
            vars.setStackFrame(this.m_stackFrame);
        } else {
            vars = null;
            savedStart = 0;
        }
        try {
            int next;
            do {
                if (this.m_extendedTypeID == 0) {
                    this.m_lastFetched = this.m_lastFetched == -1 ? this.m_traverser.first(this.m_context) : this.m_traverser.next(this.m_context, this.m_lastFetched);
                    next = this.m_lastFetched;
                    continue;
                }
                this.m_lastFetched = this.m_lastFetched == -1 ? this.m_traverser.first(this.m_context, this.m_extendedTypeID) : this.m_traverser.next(this.m_context, this.m_lastFetched, this.m_extendedTypeID);
                next = this.m_lastFetched;
            } while (next != -1 && this.acceptNode(next) != 1 && next != -1);
            if (next != -1) {
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(this.m_lastFetched);
                }
                ++this.m_next;
                int n3 = next;
                Object var6_7 = null;
                if (this.m_stackFrame == -1) return n3;
                vars.setStackFrame(savedStart);
                return n3;
            }
            this.m_foundLast = true;
            n2 = -1;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (this.m_stackFrame == -1) throw throwable;
            vars.setStackFrame(savedStart);
            throw throwable;
        }
        Object var6_8 = null;
        if (this.m_stackFrame == -1) return n2;
        vars.setStackFrame(savedStart);
        return n2;
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_traverser = this.m_cdtm.getAxisTraverser(this.m_axis);
        String localName = this.getLocalName();
        String namespace = this.getNamespace();
        int what = this.m_whatToShow;
        if (what == -1 || localName == "*" || namespace == "*") {
            this.m_extendedTypeID = 0;
        } else {
            int type = NodeTest.getNodeTypeTest(what);
            this.m_extendedTypeID = this.m_cdtm.getExpandedTypeID(namespace, localName, type);
        }
    }
}

