/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient DTMIterator m_nodeSet;

    FilterExprWalker(WalkingIterator locPathIterator) {
        super(locPathIterator, 20);
    }

    public short acceptNode(int n2) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n2, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker clone = (FilterExprWalker)super.clone();
        if (this.m_nodeSet != null) {
            clone.m_nodeSet = (DTMIterator)this.m_nodeSet.clone();
        }
        return clone;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        this.m_expr.fixupVariables(vars, globalsSize);
    }

    public int getAxis() {
        return this.m_nodeSet.getAxis();
    }

    public int getLastPos(XPathContext xctxt) {
        return this.m_nodeSet.getLength();
    }

    public int getNextNode() {
        if (this.m_nodeSet != null) {
            return this.m_nodeSet.nextNode();
        }
        return -1;
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        super.init(compiler, opPos, stepType);
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(opPos);
                break;
            }
            default: {
                this.m_expr = compiler.compile(opPos + 2);
            }
        }
    }

    public boolean isDocOrdered() {
        return this.m_nodeSet.isDocOrdered();
    }

    public void setRoot(int root) {
        XPathContext xctxt = this.m_lpi.getXPathContext();
        PrefixResolver savedResolver = xctxt.getNamespaceContext();
        try {
            try {
                xctxt.pushCurrentNode(root);
                xctxt.setNamespaceContext(this.m_lpi.getPrefixResolver());
                if (this.m_lpi.getIsTopLevel()) {
                    VariableStack vars = this.m_lpi.m_execContext.getVarStack();
                    int savedStart = vars.getStackFrame();
                    vars.setStackFrame(this.m_lpi.m_stackFrame);
                    this.m_nodeSet = this.m_expr.asIterator(xctxt, root);
                    vars.setStackFrame(savedStart);
                } else {
                    this.m_nodeSet = this.m_expr.asIterator(xctxt, root);
                }
            }
            catch (TransformerException se) {
                throw new WrappedRuntimeException(se);
            }
            Object var5_7 = null;
            xctxt.popCurrentNode();
            xctxt.setNamespaceContext(savedResolver);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            xctxt.popCurrentNode();
            xctxt.setNamespaceContext(savedResolver);
            throw throwable;
        }
        super.setRoot(root);
    }
}

