/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.WrappedRuntimeException;

public class IteratorPool
implements Serializable {
    private final DTMIterator m_orig;
    private final Vector m_freeStack;

    public IteratorPool(DTMIterator original) {
        this.m_orig = original;
        this.m_freeStack = new Vector();
    }

    public synchronized void freeInstance(DTMIterator obj) {
        this.m_freeStack.addElement(obj);
    }

    public synchronized DTMIterator getInstance() {
        if (this.m_freeStack.isEmpty()) {
            try {
                return (DTMIterator)this.m_orig.clone();
            }
            catch (Exception ex2) {
                throw new WrappedRuntimeException(ex2);
            }
        }
        DTMIterator result = (DTMIterator)this.m_freeStack.lastElement();
        this.m_freeStack.setSize(this.m_freeStack.size() - 1);
        return result;
    }
}

