/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class UnionPathIterator
extends Expression
implements Cloneable,
DTMIterator,
Serializable {
    private boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    transient NodeSetDTM m_cachedNodes = null;
    protected transient int m_next = 0;
    transient int m_lastFetched = -1;
    protected transient boolean m_foundLast = false;
    protected transient XPathContext m_execContext;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected DTMIterator[] m_iterators;
    private transient int m_last = 0;

    public UnionPathIterator() {
        this.m_iterators = null;
    }

    public UnionPathIterator(Compiler compiler, int opPos) throws TransformerException {
        opPos = OpMap.getFirstChildPos(opPos);
        this.loadLocationPaths(compiler, opPos, 0);
    }

    public void addIterator(LocPathIterator iter) {
        if (this.m_iterators == null) {
            this.m_iterators = new LocPathIterator[1];
            this.m_iterators[0] = iter;
        } else {
            DTMIterator[] iters = this.m_iterators;
            int len = this.m_iterators.length;
            this.m_iterators = new LocPathIterator[len + 1];
            System.arraycopy(iters, 0, this.m_iterators, 0, len);
            this.m_iterators[len] = iter;
        }
    }

    public void allowDetachToRelease(boolean allowRelease) {
        this.m_allowDetach = allowRelease;
    }

    public DTMIterator asIterator(XPathContext xctxt, int contextNode) throws TransformerException {
        UnionPathIterator clone = (UnionPathIterator)this.m_clones.getInstance();
        clone.setRoot(contextNode, xctxt);
        return clone;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)super.clone();
        if (this.m_iterators != null) {
            int n2 = this.m_iterators.length;
            clone.m_iterators = new LocPathIterator[n2];
            int i2 = 0;
            while (i2 < n2) {
                clone.m_iterators[i2] = (LocPathIterator)this.m_iterators[i2].clone();
                ++i2;
            }
        }
        return clone;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)this.clone();
        clone.reset();
        return clone;
    }

    protected DTMIterator createDTMIterator(Compiler compiler, int opPos) throws TransformerException {
        DTMIterator lpi = WalkerFactory.newDTMIterator(compiler, opPos, compiler.getLocationPathDepth() <= 0);
        return lpi;
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_cachedNodes = null;
            this.m_execContext = null;
            if (this.m_iterators != null) {
                int n2 = this.m_iterators.length;
                int i2 = 0;
                while (i2 < n2) {
                    this.m_iterators[i2].detach();
                    ++i2;
                }
            }
            this.m_clones.freeInstance(this);
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        UnionPathIterator clone = (UnionPathIterator)this.m_clones.getInstance();
        int current = xctxt.getCurrentNode();
        clone.setRoot(current, xctxt);
        return new XNodeSet(clone);
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        int i2 = 0;
        while (i2 < this.m_iterators.length) {
            DTMIterator iter = this.m_iterators[i2];
            if (iter instanceof Expression) {
                ((Expression)((Object)iter)).fixupVariables(vars, globalsSize);
            }
            ++i2;
        }
    }

    public int getAxis() {
        return -1;
    }

    public int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_execContext.getDTM(nodeHandle);
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLastPos(XPathContext xctxt) {
        int next;
        UnionPathIterator clone;
        int pos = this.m_next;
        int savedPos = this.m_cachedNodes != null ? this.m_cachedNodes.getCurrentPos() : -1;
        try {
            clone = pos == 0 && this.m_currentContextNode != -1 ? (UnionPathIterator)this.cloneWithReset() : (UnionPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        pos = clone.getCurrentPos();
        while ((next = clone.nextNode()) != -1) {
            ++pos;
        }
        if (savedPos != -1) {
            this.m_cachedNodes.setCurrentPos(savedPos);
        }
        return pos;
    }

    public int getLength() {
        if (this.m_last > 0) {
            return this.m_last;
        }
        this.m_last = this.m_cachedNodes == null || !this.m_foundLast ? this.getLastPos(this.m_execContext) : this.m_cachedNodes.getLength();
        return this.m_last;
    }

    public int getRoot() {
        return this.m_context;
    }

    public int getWhatToShow() {
        return -17;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public boolean isMutable() {
        return this.m_cachedNodes != null;
    }

    public int item(int index) {
        return this.m_cachedNodes.item(index);
    }

    protected void loadLocationPaths(Compiler compiler, int opPos, int count) throws TransformerException {
        int steptype = compiler.getOpMap()[opPos];
        if (steptype == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
            this.m_iterators[count] = this.createDTMIterator(compiler, opPos);
        } else {
            switch (steptype) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
                    WalkingIterator iter = new WalkingIterator(compiler.getNamespaceContext());
                    if (compiler.getLocationPathDepth() <= 0) {
                        iter.setIsTopLevel(true);
                    }
                    iter.m_firstWalker = new FilterExprWalker(iter);
                    iter.m_firstWalker.init(compiler, opPos, steptype);
                    this.m_iterators[count] = iter;
                    break;
                }
                default: {
                    this.m_iterators = new LocPathIterator[count];
                }
            }
        }
    }

    public int nextNode() {
        if (this.m_cachedNodes != null && this.m_next < this.m_cachedNodes.size()) {
            int next = this.m_cachedNodes.elementAt(this.m_next);
            ++this.m_next;
            this.m_currentContextNode = next;
            return next;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        int earliestNode = -1;
        if (this.m_iterators != null) {
            int n2 = this.m_iterators.length;
            int iteratorUsed = -1;
            int i2 = 0;
            while (i2 < n2) {
                int node = this.m_iterators[i2].getCurrentNode();
                if (node != -1) {
                    if (earliestNode == -1) {
                        iteratorUsed = i2;
                        earliestNode = node;
                    } else if (node == earliestNode) {
                        this.m_iterators[i2].nextNode();
                    } else {
                        DTM dtm = this.getDTM(node);
                        if (dtm.isNodeAfter(node, earliestNode)) {
                            iteratorUsed = i2;
                            earliestNode = node;
                        }
                    }
                }
                ++i2;
            }
            if (earliestNode != -1) {
                this.m_iterators[iteratorUsed].nextNode();
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(earliestNode);
                }
                ++this.m_next;
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = earliestNode;
        return earliestNode;
    }

    public int previousNode() {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    private void readObject(ObjectInputStream stream) throws IOException, TransformerException {
        try {
            stream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransformerException(cnfe);
        }
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_next = 0;
        this.m_last = 0;
        this.m_lastFetched = -1;
        if (this.m_iterators != null) {
            int n2 = this.m_iterators.length;
            int i2 = 0;
            while (i2 < n2) {
                this.m_iterators[i2].reset();
                this.m_iterators[i2].nextNode();
                ++i2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int index) {
        block3: {
            if (this.m_foundLast || index >= 0 && index <= this.getCurrentPos()) {
                return;
            }
            if (index != -1) ** GOTO lbl-1000
            while ((n = this.nextNode()) != -1) {
            }
            break block3;
            while (this.getCurrentPos() < index) lbl-1000:
            // 2 sources

            {
                if ((n = this.nextNode()) != -1) continue;
            }
        }
    }

    public void setCurrentPos(int i2) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.m_next = i2;
        this.m_cachedNodes.setCurrentPos(i2);
    }

    public void setEnvironment(Object environment) {
    }

    public void setItem(int node, int index) {
        this.m_cachedNodes.setElementAt(node, index);
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public final void setRoot(int n2) {
        this.m_context = n2;
    }

    public void setRoot(int context, Object environment) {
        this.m_execContext = (XPathContext)environment;
        this.m_currentContextNode = context;
        this.m_context = context;
        this.m_lastFetched = -1;
        this.m_next = 0;
        this.m_last = 0;
        this.m_foundLast = false;
        try {
            if (this.m_iterators != null) {
                int n2 = this.m_iterators.length;
                int i2 = 0;
                while (i2 < n2) {
                    this.m_iterators[i2] = ((LocPathIterator)this.m_iterators[i2]).asIterator(this.m_execContext, context);
                    this.m_iterators[i2].setRoot(context, environment);
                    this.m_iterators[i2].nextNode();
                    ++i2;
                }
            }
        }
        catch (Exception e10) {
            throw new WrappedRuntimeException(e10);
        }
    }

    public void setShouldCacheNodes(boolean b10) {
        this.m_cachedNodes = b10 ? new NodeSetDTM(this.getDTMManager()) : null;
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }
}

