/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNull;
import org.apache.xpath.objects.XObject;

public class FuncExtFunction
extends Function {
    String m_namespace;
    String m_extensionName;
    Object m_methodKey;
    Vector m_argVec = new Vector();

    public FuncExtFunction(String namespace, String extensionName, Object methodKey) {
        this.m_namespace = namespace;
        this.m_extensionName = extensionName;
        this.m_methodKey = methodKey;
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        Vector<XObject> argVec = new Vector<XObject>();
        int nArgs = this.m_argVec.size();
        int i2 = 0;
        while (i2 < nArgs) {
            Expression arg = (Expression)this.m_argVec.elementAt(i2);
            argVec.addElement(arg.execute(xctxt));
            ++i2;
        }
        ExtensionsTable etable = xctxt.getExtensionsTable();
        Object val = etable.extFunction(this.m_namespace, this.m_extensionName, argVec, this.m_methodKey, xctxt.getExpressionContext());
        XObject result = val != null ? XObject.create(val, xctxt) : new XNull();
        return result;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        if (this.m_argVec != null) {
            int nArgs = this.m_argVec.size();
            int i2 = 0;
            while (i2 < nArgs) {
                Expression arg = (Expression)this.m_argVec.elementAt(i2);
                arg.fixupVariables(vars, globalsSize);
                ++i2;
            }
        }
    }

    public void setArg(Expression arg, int argNum) throws WrongNumberArgsException {
        this.m_argVec.addElement(arg);
    }
}

