/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;

public class XNumber
extends XObject {
    double m_val;

    public XNumber(double d10) {
        this.m_val = d10;
    }

    public XNumber(Number num) {
        this.m_val = num.doubleValue();
        this.m_obj = num;
    }

    public boolean bool() {
        return !Double.isNaN(this.m_val) && this.m_val != 0.0;
    }

    public boolean equals(XObject obj2) {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        try {
            return this.m_val == obj2.num();
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
    }

    public int getType() {
        return 2;
    }

    public String getTypeString() {
        return "#NUMBER";
    }

    public boolean isStableNumber() {
        return true;
    }

    public double num() {
        return this.m_val;
    }

    public double num(XPathContext xctxt) throws TransformerException {
        return this.m_val;
    }

    public Object object() {
        if (this.m_obj == null) {
            this.m_obj = new Double(this.m_val);
        }
        return this.m_obj;
    }

    public String str() {
        String sign;
        int len;
        if (Double.isNaN(this.m_val)) {
            return "NaN";
        }
        if (Double.isInfinite(this.m_val)) {
            if (this.m_val > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        double num = this.m_val;
        String s2 = Double.toString(num);
        if (s2.charAt((len = s2.length()) - 2) == '.' && s2.charAt(len - 1) == '0') {
            if ((s2 = s2.substring(0, len - 2)).equals("-0")) {
                return "0";
            }
            return s2;
        }
        int e10 = s2.indexOf(69);
        if (e10 < 0) {
            return s2;
        }
        int exp = Integer.parseInt(s2.substring(e10 + 1));
        if (s2.charAt(0) == '-') {
            sign = "-";
            s2 = s2.substring(1);
            --e10;
        } else {
            sign = "";
        }
        int nDigits = e10 - 2;
        if (exp >= nDigits) {
            return String.valueOf(sign) + s2.substring(0, 1) + s2.substring(2, e10) + XNumber.zeros(exp - nDigits);
        }
        if (exp > 0) {
            return String.valueOf(sign) + s2.substring(0, 1) + s2.substring(2, 2 + exp) + "." + s2.substring(2 + exp, e10);
        }
        return String.valueOf(sign) + "0." + XNumber.zeros(-1 - exp) + s2.substring(0, 1) + s2.substring(2, e10);
    }

    private static String zeros(int n2) {
        if (n2 < 1) {
            return "";
        }
        char[] buf = new char[n2];
        int i2 = 0;
        while (i2 < n2) {
            buf[i2] = 48;
            ++i2;
        }
        return new String(buf);
    }
}

