/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XStringForFSB
extends XString {
    int m_start;
    int m_length;
    protected String m_strCache = null;
    protected int m_hash = 0;

    private XStringForFSB(String val) {
        super(val);
        throw new IllegalArgumentException("XStringForFSB can not take a string for an argument!");
    }

    public XStringForFSB(FastStringBuffer val, int start, int length) {
        super(val);
        this.m_start = start;
        this.m_length = length;
        if (val == null) {
            throw new IllegalArgumentException("The FastStringBuffer argument can not be null!!");
        }
    }

    public void appendToFsb(FastStringBuffer fsb) {
        fsb.append(this.str());
    }

    public char charAt(int index) {
        return this.fsb().charAt(this.m_start + index);
    }

    public int compareTo(XMLString xstr) {
        int len1 = this.m_length;
        int len2 = xstr.length();
        int n2 = Math.min(len1, len2);
        FastStringBuffer fsb = this.fsb();
        int i2 = this.m_start;
        int j2 = 0;
        while (n2-- != 0) {
            char c22;
            char c12 = fsb.charAt(i2);
            if (c12 != (c22 = xstr.charAt(j2))) {
                return c12 - c22;
            }
            ++i2;
            ++j2;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(XMLString xstr) {
        int len1 = this.m_length;
        int len2 = xstr.length();
        int n2 = Math.min(len1, len2);
        FastStringBuffer fsb = this.fsb();
        int i2 = this.m_start;
        int j2 = 0;
        while (n2-- != 0) {
            char c22;
            char c12 = Character.toLowerCase(fsb.charAt(i2));
            if (c12 != (c22 = Character.toLowerCase(xstr.charAt(j2)))) {
                return c12 - c22;
            }
            ++i2;
            ++j2;
        }
        return len1 - len2;
    }

    public XMLString concat(String str) {
        return new XString(this.str().concat(str));
    }

    public void dispatchAsComment(LexicalHandler lh) throws SAXException {
        this.fsb().sendSAXComment(lh, this.m_start, this.m_length);
    }

    public void dispatchCharactersEvents(ContentHandler ch2) throws SAXException {
        this.fsb().sendSAXcharacters(ch2, this.m_start, this.m_length);
    }

    public boolean equals(Object obj2) {
        if (obj2 == null) {
            return false;
        }
        if (obj2 instanceof XNodeSet) {
            return obj2.equals(this);
        }
        if (obj2 instanceof XStringForFSB) {
            return this.equals(this);
        }
        return this.equals(obj2.toString());
    }

    public boolean equals(String anotherString) {
        int n2 = this.m_length;
        if (n2 == anotherString.length()) {
            FastStringBuffer fsb = this.fsb();
            int i2 = this.m_start;
            int j2 = 0;
            while (n2-- != 0) {
                if (fsb.charAt(i2) != anotherString.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XMLString obj2) {
        if (this == obj2) {
            return true;
        }
        int n2 = this.m_length;
        if (n2 == obj2.length()) {
            FastStringBuffer fsb = this.fsb();
            int i2 = this.m_start;
            int j2 = 0;
            while (n2-- != 0) {
                if (fsb.charAt(i2) != obj2.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XObject obj2) {
        if (this == obj2) {
            return true;
        }
        int n2 = this.m_length;
        String str = obj2.str();
        if (n2 == str.length()) {
            FastStringBuffer fsb = this.fsb();
            int i2 = this.m_start;
            int j2 = 0;
            while (n2-- != 0) {
                if (fsb.charAt(i2) != str.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.m_length == anotherString.length() ? this.str().equalsIgnoreCase(anotherString) : false;
    }

    public XMLString fixWhiteSpace(boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        int end = this.m_length + this.m_start;
        char[] buf = new char[this.m_length];
        FastStringBuffer fsb = this.fsb();
        boolean edit = false;
        int d10 = 0;
        boolean pres = false;
        int s2 = this.m_start;
        while (s2 < end) {
            char c10 = fsb.charAt(s2);
            if (XStringForFSB.isSpace(c10)) {
                if (!pres) {
                    if (c10 != ' ') {
                        edit = true;
                    }
                    buf[d10++] = 32;
                    if (doublePunctuationSpaces && d10 != 0) {
                        char prevChar = buf[d10 - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d10++] = c10;
                pres = false;
            }
            ++s2;
        }
        if (trimTail && d10 >= 1 && buf[d10 - 1] == ' ') {
            edit = true;
            --d10;
        }
        int start = 0;
        if (trimHead && d10 > 0 && buf[0] == ' ') {
            edit = true;
            ++start;
        }
        XMLStringFactory xsf = XMLStringFactoryImpl.getFactory();
        return edit ? xsf.newstr(buf, start, d10 - start) : this;
    }

    public FastStringBuffer fsb() {
        return (FastStringBuffer)this.m_obj;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int n2 = srcEnd - srcBegin;
        if (n2 > this.m_length) {
            n2 = this.m_length;
        }
        if (n2 > dst.length - dstBegin) {
            n2 = dst.length - dstBegin;
        }
        int end = srcBegin + this.m_start + n2;
        int d10 = dstBegin;
        FastStringBuffer fsb = this.fsb();
        int i2 = srcBegin + this.m_start;
        while (i2 < end) {
            dst[d10++] = fsb.charAt(i2);
            ++i2;
        }
    }

    public boolean hasString() {
        return this.m_strCache != null;
    }

    public int hashCode() {
        int h2 = this.m_hash;
        if (h2 == 0) {
            int off = this.m_start;
            int len = this.m_length;
            FastStringBuffer fsb = this.fsb();
            int i2 = 0;
            while (i2 < len) {
                h2 = 31 * h2 + fsb.charAt(off);
                ++off;
                ++i2;
            }
            this.m_hash = h2;
        }
        return h2;
    }

    public int indexOf(int ch2) {
        return this.indexOf(ch2, 0);
    }

    public int indexOf(int ch2, int fromIndex) {
        int max = this.m_start + this.m_length;
        FastStringBuffer fsb = this.fsb();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.m_length) {
            return -1;
        }
        int i2 = this.m_start + fromIndex;
        while (i2 < max) {
            if (fsb.charAt(i2) == ch2) {
                return i2 - this.m_start;
            }
            ++i2;
        }
        return -1;
    }

    private static boolean isSpace(char ch2) {
        return XMLCharacterRecognizer.isWhiteSpace(ch2);
    }

    public int length() {
        return this.m_length;
    }

    public Object object() {
        return this.str();
    }

    public boolean startsWith(XMLString prefix) {
        return this.startsWith(prefix, 0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(XMLString prefix, int toffset) {
        fsb = this.fsb();
        to = this.m_start + toffset;
        tlim = this.m_start + this.m_length;
        po = 0;
        pc = prefix.length();
        if (toffset >= 0 && toffset <= this.m_length - pc) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            if (fsb.charAt(to) != prefix.charAt(po)) {
                return false;
            }
            ++to;
            ++po;
lbl12:
            // 2 sources

            ** while (--pc >= 0)
        }
lbl13:
        // 1 sources

        return true;
    }

    public String str() {
        if (this.m_strCache == null) {
            this.m_strCache = this.fsb().getString(this.m_start, this.m_length);
        }
        return this.m_strCache;
    }

    public XMLString substring(int beginIndex) {
        int len = this.m_length - beginIndex;
        if (len <= 0) {
            return XString.EMPTYSTRING;
        }
        int start = this.m_start + beginIndex;
        return new XStringForFSB(this.fsb(), start, len);
    }

    public XMLString substring(int beginIndex, int endIndex) {
        int len = endIndex - beginIndex;
        if (len > this.m_length) {
            len = this.m_length;
        }
        if (len <= 0) {
            return XString.EMPTYSTRING;
        }
        int start = this.m_start + beginIndex;
        return new XStringForFSB(this.fsb(), start, len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double toDouble() {
        int start = this.m_start;
        int end = this.m_length + start;
        if (end == 0) {
            return Double.NaN;
        }
        double result = 0.0;
        int punctPos = end - 1;
        FastStringBuffer fsb = this.fsb();
        int i2 = start;
        while (i2 < end) {
            char c10 = fsb.charAt(i2);
            if (!XMLCharacterRecognizer.isWhiteSpace(c10)) break;
            ++start;
            ++i2;
        }
        double sign = 1.0;
        if (start < end && fsb.charAt(start) == '-') {
            sign = -1.0;
            ++start;
        }
        int digitsFound = 0;
        int i3 = start;
        while (i3 < end) {
            char c11 = fsb.charAt(i3);
            if (c11 != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c11)) break;
                if (!Character.isDigit(c11)) return Double.NaN;
                result = result * 10.0 + (double)(c11 - 48);
                ++digitsFound;
            } else {
                punctPos = i3;
                break;
            }
            ++i3;
        }
        if (fsb.charAt(punctPos) == '.') {
            double fractPart = 0.0;
            int i4 = end - 1;
            while (i4 > punctPos) {
                char c12 = fsb.charAt(i4);
                if (!XMLCharacterRecognizer.isWhiteSpace(c12)) {
                    if (!Character.isDigit(c12)) return Double.NaN;
                    fractPart = fractPart / 10.0 + (double)(c12 - 48);
                    ++digitsFound;
                }
                --i4;
            }
            result += fractPart / 10.0;
        }
        if (digitsFound != 0) return result * sign;
        return Double.NaN;
    }

    public XMLString trim() {
        return this.fixWhiteSpace(true, true, false);
    }
}

