/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class FunctionPattern
extends StepPattern {
    Expression m_functionExpr;

    public FunctionPattern(Expression expr, int axis, int predaxis) {
        super(0, null, null, axis, predaxis);
        this.m_functionExpr = expr;
    }

    public final void calcScore() {
        this.m_score = NodeTest.SCORE_OTHER;
        if (this.m_targetString == null) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        int context = xctxt.getCurrentNode();
        DTMIterator nl = this.m_functionExpr.asIterator(xctxt, context);
        XNumber score = NodeTest.SCORE_NONE;
        if (nl != null) {
            int n2;
            while ((n2 = nl.nextNode()) != -1) {
                XNumber xNumber = score = n2 == context ? NodeTest.SCORE_OTHER : NodeTest.SCORE_NONE;
                if (score != NodeTest.SCORE_OTHER) continue;
                context = n2;
                break;
            }
            nl.detach();
        }
        return score;
    }

    public XObject execute(XPathContext xctxt, int context) throws TransformerException {
        DTMIterator nl = this.m_functionExpr.asIterator(xctxt, context);
        XNumber score = NodeTest.SCORE_NONE;
        if (nl != null) {
            int n2;
            while ((n2 = nl.nextNode()) != -1) {
                XNumber xNumber = score = n2 == context ? NodeTest.SCORE_OTHER : NodeTest.SCORE_NONE;
                if (score != NodeTest.SCORE_OTHER) continue;
                context = n2;
                break;
            }
        }
        nl.detach();
        return score;
    }

    public XObject execute(XPathContext xctxt, int context, DTM dtm, int expType) throws TransformerException {
        DTMIterator nl = this.m_functionExpr.asIterator(xctxt, context);
        XNumber score = NodeTest.SCORE_NONE;
        if (nl != null) {
            int n2;
            while ((n2 = nl.nextNode()) != -1) {
                XNumber xNumber = score = n2 == context ? NodeTest.SCORE_OTHER : NodeTest.SCORE_NONE;
                if (score != NodeTest.SCORE_OTHER) continue;
                context = n2;
                break;
            }
            nl.detach();
        }
        return score;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        this.m_functionExpr.fixupVariables(vars, globalsSize);
    }
}

