/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;

public class NodeTest
extends Expression {
    public static final String WILD = "*";
    public static final String SUPPORTS_PRE_STRIPPING = "http://xml.apache.org/xpath/features/whitespace-pre-stripping";
    protected int m_whatToShow;
    public static final int SHOW_BYFUNCTION = 65536;
    String m_namespace;
    protected String m_name;
    XNumber m_score;
    public static final XNumber SCORE_NODETEST = new XNumber(-0.5);
    public static final XNumber SCORE_NSWILD = new XNumber(-0.25);
    public static final XNumber SCORE_QNAME = new XNumber(0.0);
    public static final XNumber SCORE_OTHER = new XNumber(0.5);
    public static final XNumber SCORE_NONE = new XNumber(Double.NEGATIVE_INFINITY);
    private boolean m_isTotallyWild;

    public NodeTest() {
    }

    public NodeTest(int whatToShow) {
        this.initNodeTest(whatToShow);
    }

    public NodeTest(int whatToShow, String namespace, String name) {
        this.initNodeTest(whatToShow, namespace, name);
    }

    protected void calcScore() {
        this.m_score = this.m_namespace == null && this.m_name == null ? SCORE_NODETEST : ((this.m_namespace == WILD || this.m_namespace == null) && this.m_name == WILD ? SCORE_NODETEST : (this.m_namespace != WILD && this.m_name == WILD ? SCORE_NSWILD : SCORE_QNAME));
        this.m_isTotallyWild = this.m_namespace == null && this.m_name == WILD;
    }

    public static void debugWhatToShow(int whatToShow) {
        Vector<String> v2 = new Vector<String>();
        if ((whatToShow & 2) != 0) {
            v2.addElement("SHOW_ATTRIBUTE");
        }
        if ((whatToShow & 0x1000) != 0) {
            v2.addElement("SHOW_NAMESPACE");
        }
        if ((whatToShow & 8) != 0) {
            v2.addElement("SHOW_CDATA_SECTION");
        }
        if ((whatToShow & 0x80) != 0) {
            v2.addElement("SHOW_COMMENT");
        }
        if ((whatToShow & 0x100) != 0) {
            v2.addElement("SHOW_DOCUMENT");
        }
        if ((whatToShow & 0x400) != 0) {
            v2.addElement("SHOW_DOCUMENT_FRAGMENT");
        }
        if ((whatToShow & 0x200) != 0) {
            v2.addElement("SHOW_DOCUMENT_TYPE");
        }
        if ((whatToShow & 1) != 0) {
            v2.addElement("SHOW_ELEMENT");
        }
        if ((whatToShow & 0x20) != 0) {
            v2.addElement("SHOW_ENTITY");
        }
        if ((whatToShow & 0x10) != 0) {
            v2.addElement("SHOW_ENTITY_REFERENCE");
        }
        if ((whatToShow & 0x800) != 0) {
            v2.addElement("SHOW_NOTATION");
        }
        if ((whatToShow & 0x40) != 0) {
            v2.addElement("SHOW_PROCESSING_INSTRUCTION");
        }
        if ((whatToShow & 4) != 0) {
            v2.addElement("SHOW_TEXT");
        }
        int n2 = v2.size();
        int i2 = 0;
        while (i2 < n2) {
            if (i2 > 0) {
                System.out.print(" | ");
            }
            System.out.print(v2.elementAt(i2));
            ++i2;
        }
        if (n2 == 0) {
            System.out.print("empty whatToShow: " + whatToShow);
        }
        System.out.println();
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    public XObject execute(XPathContext xctxt, int context) throws TransformerException {
        DTM dtm = xctxt.getDTM(context);
        short nodeType = dtm.getNodeType(context);
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int nodeBit = this.m_whatToShow & 1 << nodeType - 1;
        switch (nodeBit) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dtm.getNodeName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String ns = dtm.getNodeValue(context);
                return NodeTest.subPartMatch(ns, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dtm.getNamespaceURI(context), this.m_namespace) && NodeTest.subPartMatch(dtm.getLocalName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    public XObject execute(XPathContext xctxt, int context, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int nodeBit = this.m_whatToShow & 1 << (expType >> ExpandedNameTable.ROTAMOUNT_TYPE) - 1;
        switch (nodeBit) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dtm.getNodeName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String ns = dtm.getNodeValue(context);
                return NodeTest.subPartMatch(ns, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dtm.getNamespaceURI(context), this.m_namespace) && NodeTest.subPartMatch(dtm.getLocalName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
    }

    public double getDefaultScore() {
        return this.m_score.num();
    }

    public String getLocalName() {
        return this.m_name == null ? "" : this.m_name;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public static int getNodeTypeTest(int whatToShow) {
        if ((whatToShow & 1) != 0) {
            return 1;
        }
        if ((whatToShow & 2) != 0) {
            return 2;
        }
        if ((whatToShow & 4) != 0) {
            return 3;
        }
        if ((whatToShow & 0x100) != 0) {
            return 9;
        }
        if ((whatToShow & 0x400) != 0) {
            return 11;
        }
        if ((whatToShow & 0x1000) != 0) {
            return 13;
        }
        if ((whatToShow & 0x80) != 0) {
            return 8;
        }
        if ((whatToShow & 0x40) != 0) {
            return 7;
        }
        if ((whatToShow & 0x200) != 0) {
            return 10;
        }
        if ((whatToShow & 0x20) != 0) {
            return 6;
        }
        if ((whatToShow & 0x10) != 0) {
            return 5;
        }
        if ((whatToShow & 0x800) != 0) {
            return 12;
        }
        if ((whatToShow & 8) != 0) {
            return 4;
        }
        return 0;
    }

    public XNumber getStaticScore() {
        return this.m_score;
    }

    public int getWhatToShow() {
        return this.m_whatToShow;
    }

    public void initNodeTest(int whatToShow) {
        this.m_whatToShow = whatToShow;
        this.calcScore();
    }

    public void initNodeTest(int whatToShow, String namespace, String name) {
        this.m_whatToShow = whatToShow;
        this.m_namespace = namespace;
        this.m_name = name;
        this.calcScore();
    }

    public void setLocalName(String name) {
        this.m_name = name;
    }

    public void setNamespace(String ns) {
        this.m_namespace = ns;
    }

    public void setStaticScore(XNumber score) {
        this.m_score = score;
    }

    public void setWhatToShow(int what) {
        this.m_whatToShow = what;
    }

    private static final boolean subPartMatch(String p2, String t2) {
        return p2 == t2 || p2 != null && (t2 == WILD || p2.equals(t2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean subPartMatchNS(String p2, String t2) {
        if (p2 == t2) return true;
        if (p2 == null) return false;
        if (p2.length() > 0) {
            if (t2 == WILD) return true;
            if (p2.equals(t2)) return true;
            return false;
        }
        if (t2 == null) return true;
        return false;
    }
}

