/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList {
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int whatToShow, int axis, int axisForPredicate) {
        super(whatToShow);
        this.m_axis = axis;
    }

    public StepPattern(int whatToShow, String namespace, String name, int axis, int axisForPredicate) {
        super(whatToShow, namespace, name);
        this.m_axis = axis;
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || this.m_relativePathPattern != null) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (this.m_targetString == null) {
            this.calcTargetString();
        }
    }

    public void calcTargetString() {
        int whatToShow = this.getWhatToShow();
        switch (whatToShow) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if (this.m_name == "*") {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public boolean canTraverseOutsideSubtree() {
        int n2 = this.getPredicateCount();
        int i2 = 0;
        while (i2 < n2) {
            if (this.getPredicate(i2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkProximityPosition(XPathContext xctxt, int predPos, DTM dtm, int context, int pos) {
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(12);
            int child = traverser.first(context);
            while (child != -1) {
                Object var10_9;
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                        Object var13_11;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList(this);
                            int i2 = 0;
                            while (i2 < predPos) {
                                Object var16_13;
                                xctxt.pushPredicatePos(i2);
                                try {
                                    Object var19_15;
                                    XObject pred;
                                    block16: {
                                        pred = this.m_predicates[i2].execute(xctxt);
                                        try {
                                            if (pred.getType() == 2) {
                                                throw new Error("Why: Should never have been called");
                                            }
                                            if (pred.boolWithSideEffects()) break block16;
                                            pass = false;
                                            var19_15 = null;
                                            pred.detach();
                                        }
                                        catch (Throwable throwable) {
                                            var19_15 = null;
                                            pred.detach();
                                            throw throwable;
                                        }
                                        var16_13 = null;
                                        xctxt.popPredicatePos();
                                        break;
                                    }
                                    var19_15 = null;
                                    pred.detach();
                                }
                                catch (Throwable throwable) {
                                    var16_13 = null;
                                    xctxt.popPredicatePos();
                                    throw throwable;
                                }
                                var16_13 = null;
                                xctxt.popPredicatePos();
                                ++i2;
                            }
                        }
                        catch (Throwable throwable) {
                            var13_11 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        var13_11 = null;
                        xctxt.popSubContextList();
                        if (pass) {
                            --pos;
                        }
                        if (pos < 1) {
                            boolean bl2 = false;
                            var10_9 = null;
                            xctxt.popCurrentNode();
                            return bl2;
                        }
                    }
                    var10_9 = null;
                    xctxt.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
                child = traverser.next(context, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        if (pos == 1) return true;
        return false;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    public XObject execute(XPathContext xctxt, int currentNode) throws TransformerException {
        DTM dtm = xctxt.getDTM(currentNode);
        if (dtm != null) {
            int expType = dtm.getExpandedTypeID(currentNode);
            return this.execute(xctxt, currentNode, dtm, expType);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xctxt, int currentNode, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (this.m_relativePathPattern != null) {
                return this.m_relativePathPattern.execute(xctxt);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject score = super.execute(xctxt, currentNode, dtm, expType);
        if (score == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xctxt, dtm, currentNode)) {
            return NodeTest.SCORE_NONE;
        }
        if (this.m_relativePathPattern != null) {
            return this.m_relativePathPattern.executeRelativePathPattern(xctxt, dtm, currentNode);
        }
        return score;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean executePredicates(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        boolean result = true;
        boolean positionAlreadySeen = false;
        int n2 = this.getPredicateCount();
        try {
            xctxt.pushSubContextList(this);
            int i2 = 0;
            while (i2 < n2) {
                Object var11_8;
                block16: {
                    block15: {
                        block14: {
                            xctxt.pushPredicatePos(i2);
                            try {
                                Object var14_10;
                                XObject pred;
                                block10: {
                                    block12: {
                                        block11: {
                                            block9: {
                                                pred = this.m_predicates[i2].execute(xctxt);
                                                try {
                                                    if (pred.getType() == 2) {
                                                        int pos = (int)pred.num();
                                                        if (positionAlreadySeen) {
                                                            result = pos == 1;
                                                            var14_10 = null;
                                                            pred.detach();
                                                            break block9;
                                                        }
                                                        positionAlreadySeen = true;
                                                        if (this.checkProximityPosition(xctxt, i2, dtm, currentNode, pos)) break block10;
                                                        result = false;
                                                        break block11;
                                                    }
                                                    if (pred.boolWithSideEffects()) break block10;
                                                    result = false;
                                                    break block12;
                                                }
                                                catch (Throwable throwable) {
                                                    var14_10 = null;
                                                    pred.detach();
                                                    throw throwable;
                                                }
                                            }
                                            var11_8 = null;
                                            xctxt.popPredicatePos();
                                            break;
                                        }
                                        var14_10 = null;
                                        pred.detach();
                                        break block14;
                                    }
                                    var14_10 = null;
                                    pred.detach();
                                    break block15;
                                }
                                var14_10 = null;
                                pred.detach();
                                break block16;
                            }
                            catch (Throwable throwable) {
                                var11_8 = null;
                                xctxt.popPredicatePos();
                                throw throwable;
                            }
                        }
                        var11_8 = null;
                        xctxt.popPredicatePos();
                        break;
                    }
                    var11_8 = null;
                    xctxt.popPredicatePos();
                    break;
                }
                var11_8 = null;
                xctxt.popPredicatePos();
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            xctxt.popSubContextList();
            throw throwable;
        }
        Object var8_14 = null;
        xctxt.popSubContextList();
        return result;
    }

    protected final XObject executeRelativePathPattern(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        XObject score = NodeTest.SCORE_NONE;
        int context = currentNode;
        DTMAxisTraverser traverser = dtm.getAxisTraverser(this.m_axis);
        int relative = traverser.first(context);
        while (relative != -1) {
            Object var9_8;
            try {
                xctxt.pushCurrentNode(relative);
                score = this.execute(xctxt);
                if (score != NodeTest.SCORE_NONE) {
                    var9_8 = null;
                    xctxt.popCurrentNode();
                    break;
                }
                var9_8 = null;
                xctxt.popCurrentNode();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
            relative = traverser.next(context, relative);
        }
        return score;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        if (this.m_predicates != null) {
            int i2 = 0;
            while (i2 < this.m_predicates.length) {
                this.m_predicates[i2].fixupVariables(vars, globalsSize);
                ++i2;
            }
        }
        if (this.m_relativePathPattern != null) {
            this.m_relativePathPattern.fixupVariables(vars, globalsSize);
        }
    }

    public int getAxis() {
        return this.m_axis;
    }

    public int getLastPos(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), true);
    }

    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.execute(xctxt);
            double d10 = score.num();
            Object var6_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d10;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public Expression getPredicate(int i2) {
        return this.m_predicates[i2];
    }

    public final int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xctxt, int predPos, boolean findLast) {
        int pos = 0;
        int context = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(context);
        int parent = dtm.getParent(context);
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(3);
            int child = traverser.first(parent);
            while (true) {
                Object var12_11;
                if (child == -1) {
                    return pos;
                }
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                        Object var15_13;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList(this);
                            int i2 = 0;
                            while (i2 < predPos) {
                                Object var18_15;
                                block22: {
                                    block21: {
                                        xctxt.pushPredicatePos(i2);
                                        try {
                                            Object var21_17;
                                            XObject pred;
                                            block17: {
                                                block19: {
                                                    block18: {
                                                        pred = this.m_predicates[i2].execute(xctxt);
                                                        try {
                                                            if (pred.getType() == 2) {
                                                                if (pos + 1 == (int)pred.numWithSideEffects()) break block17;
                                                                pass = false;
                                                                var21_17 = null;
                                                                pred.detach();
                                                                break block18;
                                                            }
                                                            if (pred.boolWithSideEffects()) break block17;
                                                            pass = false;
                                                            break block19;
                                                        }
                                                        catch (Throwable throwable) {
                                                            var21_17 = null;
                                                            pred.detach();
                                                            throw throwable;
                                                        }
                                                    }
                                                    var18_15 = null;
                                                    xctxt.popPredicatePos();
                                                    break;
                                                }
                                                var21_17 = null;
                                                pred.detach();
                                                break block21;
                                            }
                                            var21_17 = null;
                                            pred.detach();
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            var18_15 = null;
                                            xctxt.popPredicatePos();
                                            throw throwable;
                                        }
                                    }
                                    var18_15 = null;
                                    xctxt.popPredicatePos();
                                    break;
                                }
                                var18_15 = null;
                                xctxt.popPredicatePos();
                                ++i2;
                            }
                        }
                        catch (Throwable throwable) {
                            var15_13 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        var15_13 = null;
                        xctxt.popSubContextList();
                        if (pass) {
                            ++pos;
                        }
                        if (!findLast && child == context) {
                            int n2 = pos;
                            var12_11 = null;
                            xctxt.popCurrentNode();
                            return n2;
                        }
                    }
                    var12_11 = null;
                    xctxt.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
                child = traverser.next(parent, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void setAxis(int axis) {
        this.m_axis = axis;
    }

    public void setPredicates(Expression[] predicates) {
        this.m_predicates = predicates;
        this.calcScore();
    }

    public void setRelativePathPattern(StepPattern expr) {
        this.m_relativePathPattern = expr;
        this.calcScore();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        StepPattern pat = this;
        while (pat != null) {
            if (pat != this) {
                buf.append("/");
            }
            buf.append(Axis.names[pat.m_axis]);
            buf.append("::");
            if (pat.m_whatToShow == 20480) {
                buf.append("doc()");
            } else if (pat.m_whatToShow == 65536) {
                buf.append("function()");
            } else if (pat.m_whatToShow == -1) {
                buf.append("node()");
            } else if (pat.m_whatToShow == 4) {
                buf.append("text()");
            } else if (pat.m_whatToShow == 64) {
                buf.append("processing-instruction(");
                if (pat.m_name != null) {
                    buf.append(pat.m_name);
                }
                buf.append(")");
            } else if (pat.m_whatToShow == 128) {
                buf.append("comment()");
            } else if (pat.m_name != null) {
                if (pat.m_whatToShow == 2) {
                    buf.append("@");
                }
                if (pat.m_namespace != null) {
                    buf.append("{");
                    buf.append(pat.m_namespace);
                    buf.append("}");
                }
                buf.append(pat.m_name);
            } else if (pat.m_whatToShow == 2) {
                buf.append("@");
            } else if (pat.m_whatToShow == 1280) {
                buf.append("doc-root()");
            } else {
                buf.append("?" + Integer.toHexString(pat.m_whatToShow));
            }
            if (pat.m_predicates != null) {
                int i2 = 0;
                while (i2 < pat.m_predicates.length) {
                    buf.append("[");
                    buf.append(pat.m_predicates[i2]);
                    buf.append("]");
                    ++i2;
                }
            }
            pat = pat.m_relativePathPattern;
        }
        return buf.toString();
    }
}

