/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.IOException;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;

public abstract class ClassType
extends CompoundType {
    private ClassType parent;

    public ClassType getSuperclass() {
        return this.parent;
    }

    public void print(IndentingWriter indentingWriter, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        if (this.isInner()) {
            indentingWriter.p("// " + this.getTypeDescription() + " (INNER)");
        } else {
            indentingWriter.p("// " + this.getTypeDescription());
        }
        indentingWriter.pln(" (" + this.getRepositoryID() + ")\n");
        this.printPackageOpen(indentingWriter, bl3);
        if (!bl3) {
            indentingWriter.p("public ");
        }
        String string = "";
        indentingWriter.p("class " + this.getTypeName(false, bl3, false));
        if (this.printExtends(indentingWriter, bl2, bl3, bl4)) {
            string = ",";
        }
        this.printImplements(indentingWriter, string, bl2, bl3, bl4);
        indentingWriter.plnI(" {");
        this.printMembers(indentingWriter, bl2, bl3, bl4);
        indentingWriter.pln();
        this.printMethods(indentingWriter, bl2, bl3, bl4);
        if (bl3) {
            indentingWriter.pOln("};");
        } else {
            indentingWriter.pOln("}");
        }
        this.printPackageClose(indentingWriter, bl3);
    }

    protected void destroy() {
        if (!this.destroyed) {
            super.destroy();
            if (this.parent != null) {
                this.parent.destroy();
                this.parent = null;
            }
        }
    }

    protected ClassType(ContextStack contextStack, int n2, ClassDefinition classDefinition) {
        super(contextStack, n2, classDefinition);
        if ((n2 & 0x4000000) == 0 && classDefinition.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected ClassType(int n2, ClassDefinition classDefinition, ContextStack contextStack) {
        super(contextStack, classDefinition, n2);
        if ((n2 & 0x4000000) == 0 && classDefinition.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected ClassType(ContextStack contextStack, ClassDefinition classDefinition, int n2) {
        super(contextStack, classDefinition, n2);
        if ((n2 & 0x4000000) == 0 && classDefinition.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected void swapInvalidTypes() {
        super.swapInvalidTypes();
        if (this.parent != null && this.parent.getStatus() != 1) {
            this.parent = (ClassType)this.getValidType(this.parent);
        }
    }

    public String addExceptionDescription(String string) {
        if (this.isException) {
            string = this.isCheckedException ? string + " - Checked Exception" : string + " - Unchecked Exception";
        }
        return string;
    }

    protected boolean initParents(ContextStack contextStack) {
        contextStack.setNewContextCode(11);
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        boolean bl2 = true;
        try {
            ClassDeclaration classDeclaration = this.getClassDefinition().getSuperClass((Environment)batchEnvironment);
            if (classDeclaration != null) {
                ClassDefinition classDefinition = classDeclaration.getClassDefinition((Environment)batchEnvironment);
                this.parent = (ClassType)CompoundType.makeType(classDefinition.getType(), classDefinition, contextStack);
                if (this.parent == null) {
                    bl2 = false;
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            Type.classNotFound(contextStack, classNotFound);
            throw new CompilerError("ClassType constructor");
        }
        return bl2;
    }
}

