/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import com.sun.corba.se.internal.util.RepositoryId;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.NameContext;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;

public class IDLNames
implements Constants {
    public static final byte[] ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String getMemberOrMethodName(NameContext nameContext, String string, BatchEnvironment batchEnvironment) {
        String string2 = (String)batchEnvironment.namesCache.get(string);
        if (string2 == null) {
            string2 = nameContext.get(string);
            string2 = IDLNames.convertLeadingUnderscores(string2);
            string2 = IDLNames.convertIDLKeywords(string2);
            string2 = IDLNames.convertToISOLatin1(string2);
            batchEnvironment.namesCache.put(string, string2);
        }
        return string2;
    }

    public static String convertToISOLatin1(String string) {
        String string2 = IDLNames.replace(string, "x\\u", "U");
        string2 = IDLNames.replace(string2, "x\\U", "U");
        int n2 = string2.length();
        StringBuffer stringBuffer = null;
        int n3 = 0;
        while (n3 < n2) {
            char c10 = string2.charAt(n3);
            if (c10 > '\u00ff' || RepositoryId.IDL_IDENTIFIER_CHARS[c10] == 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string2.substring(0, n3));
                }
                stringBuffer.append("U");
                stringBuffer.append((char)ASCII_HEX[(c10 & 0xF000) >>> 12]);
                stringBuffer.append((char)ASCII_HEX[(c10 & 0xF00) >>> 8]);
                stringBuffer.append((char)ASCII_HEX[(c10 & 0xF0) >>> 4]);
                stringBuffer.append((char)ASCII_HEX[c10 & 0xF]);
            } else if (stringBuffer != null) {
                stringBuffer.append(c10);
            }
            ++n3;
        }
        if (stringBuffer != null) {
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String convertIDLKeywords(String string) {
        int n2 = 0;
        while (n2 < Constants.IDL_KEYWORDS.length) {
            if (string.equalsIgnoreCase(Constants.IDL_KEYWORDS[n2])) {
                return "_" + string;
            }
            ++n2;
        }
        return string;
    }

    public static String convertLeadingUnderscores(String string) {
        if (string.startsWith("_")) {
            return "J" + string;
        }
        return string;
    }

    public static String getClassOrInterfaceName(Identifier identifier, BatchEnvironment batchEnvironment) throws Exception {
        String string;
        String string2 = identifier.getName().toString();
        String string3 = null;
        if (identifier.isQualified()) {
            string3 = identifier.getQualifier().toString();
        }
        if ((string = (String)batchEnvironment.namesCache.get(string2)) == null) {
            string = IDLNames.replace(string2, ". ", "__");
            string = IDLNames.convertToISOLatin1(string);
            NameContext nameContext = NameContext.forName(string3, false, batchEnvironment);
            nameContext.assertPut(string);
            string = IDLNames.getTypeOrModuleName(string);
            batchEnvironment.namesCache.put(string2, string);
        }
        return string;
    }

    public static String getExceptionName(String string) {
        String string2 = string;
        string2 = string.endsWith("Exception") ? IDLNames.stripLeadingUnderscore(string.substring(0, string.lastIndexOf("Exception")) + "Ex") : string + "Ex";
        return string2;
    }

    public static String[] getModuleNames(Identifier identifier, boolean bl2, BatchEnvironment batchEnvironment) throws Exception {
        Identifier identifier2;
        Identifier identifier3 = null;
        if (identifier.isQualified()) {
            identifier2 = identifier.getQualifier();
            batchEnvironment.modulesContext.assertPut(identifier2.toString());
            int n2 = 1;
            Identifier identifier4 = identifier2;
            while (identifier4.isQualified()) {
                identifier4 = identifier4.getQualifier();
                ++n2;
            }
            identifier3 = new String[n2];
            int n3 = n2 - 1;
            identifier4 = identifier2;
            int n4 = 0;
            while (n4 < n2) {
                String string = identifier4.getName().toString();
                String string2 = (String)batchEnvironment.namesCache.get(string);
                if (string2 == null) {
                    string2 = IDLNames.convertToISOLatin1(string);
                    string2 = IDLNames.getTypeOrModuleName(string2);
                    batchEnvironment.namesCache.put(string, string2);
                }
                identifier3[n3--] = string2;
                identifier4 = identifier4.getQualifier();
                ++n4;
            }
        }
        if (bl2) {
            if (identifier3 == null) {
                identifier3 = Constants.IDL_BOXEDIDL_MODULE;
            } else {
                identifier2 = new String[((String[])identifier3).length + Constants.IDL_BOXEDIDL_MODULE.length];
                System.arraycopy(Constants.IDL_BOXEDIDL_MODULE, 0, identifier2, 0, Constants.IDL_BOXEDIDL_MODULE.length);
                System.arraycopy(identifier3, 0, identifier2, Constants.IDL_BOXEDIDL_MODULE.length, ((String[])identifier3).length);
                identifier3 = identifier2;
            }
        }
        return identifier3;
    }

    public static String getArrayName(Type type, int n2) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("seq");
        stringBuffer.append(Integer.toString(n2));
        stringBuffer.append("_");
        stringBuffer.append(IDLNames.replace(IDLNames.stripLeadingUnderscore(type.getIDLName()), " ", "_"));
        return stringBuffer.toString();
    }

    public static String[] getArrayModuleNames(Type type) {
        String[] stringArray;
        String[] stringArray2 = type.getIDLModuleNames();
        int n2 = stringArray2.length;
        if (n2 == 0) {
            stringArray = Constants.IDL_SEQUENCE_MODULE;
        } else {
            stringArray = new String[n2 + Constants.IDL_SEQUENCE_MODULE.length];
            System.arraycopy(Constants.IDL_SEQUENCE_MODULE, 0, stringArray, 0, Constants.IDL_SEQUENCE_MODULE.length);
            System.arraycopy(stringArray2, 0, stringArray, Constants.IDL_SEQUENCE_MODULE.length, n2);
        }
        return stringArray;
    }

    private static int getInitialAttributeKind(CompoundType.Method method, BatchEnvironment batchEnvironment) throws ClassNotFound {
        int n2 = 0;
        if (!method.isConstructor()) {
            boolean bl2 = true;
            ValueType[] valueTypeArray = method.getExceptions();
            if (valueTypeArray.length > 0) {
                int n3 = 0;
                while (n3 < valueTypeArray.length) {
                    if (valueTypeArray[n3].isCheckedException() && !valueTypeArray[n3].isRemoteExceptionOrSubclass()) {
                        bl2 = false;
                        break;
                    }
                    ++n3;
                }
            } else {
                bl2 = method.getEnclosing().isType(32768);
            }
            if (bl2) {
                String string = method.getName();
                int n4 = string.length();
                int n5 = method.getArguments().length;
                Type type = method.getReturnType();
                boolean bl3 = type.isType(1);
                boolean bl4 = type.isType(2);
                if (string.startsWith("get") && n4 > 3 && n5 == 0 && !bl3) {
                    n2 = 2;
                } else if (string.startsWith("is") && n4 > 2 && n5 == 0 && bl4) {
                    n2 = 1;
                } else if (string.startsWith("set") && n4 > 3 && n5 == 1 && bl3) {
                    n2 = 5;
                }
            }
        }
        return n2;
    }

    private static void setAttributeKinds(CompoundType.Method[] methodArray, int[] nArray, String[] stringArray) {
        int n2;
        int n3 = methodArray.length;
        int n4 = 0;
        while (n4 < n3) {
            switch (nArray[n4]) {
                case 2: {
                    stringArray[n4] = stringArray[n4].substring(3);
                    break;
                }
                case 1: {
                    stringArray[n4] = stringArray[n4].substring(2);
                    break;
                }
                case 5: {
                    stringArray[n4] = stringArray[n4].substring(3);
                }
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            if (nArray[n5] == 1) {
                n2 = 0;
                while (n2 < n3) {
                    Type type;
                    Type type2;
                    if (n2 != n5 && (nArray[n2] == 2 || nArray[n2] == 5) && stringArray[n5].equals(stringArray[n2]) && !(type2 = methodArray[n5].getReturnType()).equals(type = nArray[n2] == 2 ? methodArray[n2].getReturnType() : methodArray[n2].getArguments()[0])) {
                        nArray[n5] = 0;
                        stringArray[n5] = methodArray[n5].getName();
                        break;
                    }
                    ++n2;
                }
            }
            ++n5;
        }
        n2 = 0;
        while (n2 < n3) {
            if (nArray[n2] == 5) {
                int n6 = -1;
                int n7 = -1;
                int n8 = 0;
                while (n8 < n3) {
                    Type type;
                    Type type3;
                    if (n8 != n2 && stringArray[n2].equals(stringArray[n8]) && (type3 = methodArray[n8].getReturnType()).equals(type = methodArray[n2].getArguments()[0])) {
                        if (nArray[n8] == 1) {
                            n7 = n8;
                        } else if (nArray[n8] == 2) {
                            n6 = n8;
                        }
                    }
                    ++n8;
                }
                if (n6 > -1) {
                    if (n7 > -1) {
                        nArray[n7] = 3;
                        methodArray[n7].setAttributePairIndex(n2);
                        methodArray[n2].setAttributePairIndex(n7);
                        nArray[n6] = 0;
                        stringArray[n6] = methodArray[n6].getName();
                    } else {
                        nArray[n6] = 4;
                        methodArray[n6].setAttributePairIndex(n2);
                        methodArray[n2].setAttributePairIndex(n6);
                    }
                } else if (n7 > -1) {
                    nArray[n7] = 3;
                    methodArray[n7].setAttributePairIndex(n2);
                    methodArray[n2].setAttributePairIndex(n7);
                } else {
                    nArray[n2] = 0;
                    stringArray[n2] = methodArray[n2].getName();
                }
            }
            ++n2;
        }
        int n9 = 0;
        while (n9 < n3) {
            String string;
            if (nArray[n9] != 0 && Character.isUpperCase((string = stringArray[n9]).charAt(0)) && (string.length() == 1 || Character.isLowerCase(string.charAt(1)))) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(0, Character.toLowerCase(string.charAt(0)));
                stringArray[n9] = stringBuffer.toString();
            }
            methodArray[n9].setAttributeKind(nArray[n9]);
            ++n9;
        }
    }

    public static void setMethodNames(CompoundType compoundType, CompoundType.Method[] methodArray, BatchEnvironment batchEnvironment) throws Exception {
        Object object;
        int n2;
        Object object2;
        int n3 = methodArray.length;
        if (n3 == 0) {
            return;
        }
        String[] stringArray = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray[n4] = methodArray[n4].getName();
            ++n4;
        }
        CompoundType compoundType2 = methodArray[0].getEnclosing();
        if (compoundType2.isType(4096) || compoundType2.isType(8192) || compoundType2.isType(32768)) {
            object2 = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                object2[n2] = IDLNames.getInitialAttributeKind(methodArray[n2], batchEnvironment);
                ++n2;
            }
            IDLNames.setAttributeKinds(methodArray, (int[])object2, stringArray);
        }
        object2 = new NameContext(true);
        n2 = 0;
        while (n2 < n3) {
            ((NameContext)object2).put(stringArray[n2]);
            ++n2;
        }
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n3) {
            if (!methodArray[n5].isConstructor()) {
                stringArray[n5] = IDLNames.getMemberOrMethodName((NameContext)object2, stringArray[n5], batchEnvironment);
            } else {
                stringArray[n5] = "create";
                bl2 = true;
            }
            ++n5;
        }
        boolean[] blArray = new boolean[n3];
        int n6 = 0;
        while (n6 < n3) {
            blArray[n6] = !methodArray[n6].isAttribute() && !methodArray[n6].isConstructor() && IDLNames.doesMethodCollide(stringArray[n6], methodArray[n6], methodArray, stringArray, true);
            ++n6;
        }
        IDLNames.convertOverloadedMethods(methodArray, stringArray, blArray);
        int n7 = 0;
        while (n7 < n3) {
            blArray[n7] = !methodArray[n7].isAttribute() && methodArray[n7].isConstructor() && IDLNames.doesConstructorCollide(stringArray[n7], methodArray[n7], methodArray, stringArray, true);
            ++n7;
        }
        IDLNames.convertOverloadedMethods(methodArray, stringArray, blArray);
        int n8 = 0;
        while (n8 < n3) {
            object = methodArray[n8];
            if (((CompoundType.Method)object).isAttribute() && IDLNames.doesMethodCollide(stringArray[n8], (CompoundType.Method)object, methodArray, stringArray, true)) {
                int n9 = n8;
                stringArray[n9] = stringArray[n9] + "__";
            }
            ++n8;
        }
        if (bl2) {
            int n10 = 0;
            while (n10 < n3) {
                CompoundType.Method method = methodArray[n10];
                if (method.isConstructor() && IDLNames.doesConstructorCollide(stringArray[n10], method, methodArray, stringArray, false)) {
                    int n11 = n10;
                    stringArray[n11] = stringArray[n11] + "__";
                }
                ++n10;
            }
        }
        object = compoundType.getIDLName();
        int n12 = 0;
        while (n12 < n3) {
            if (stringArray[n12].equalsIgnoreCase((String)object)) {
                int n13 = n12;
                stringArray[n13] = stringArray[n13] + "_";
            }
            ++n12;
        }
        int n14 = 0;
        while (n14 < n3) {
            if (IDLNames.doesMethodCollide(stringArray[n14], methodArray[n14], methodArray, stringArray, false)) {
                throw new Exception(methodArray[n14].toString());
            }
            ++n14;
        }
        int n15 = 0;
        while (n15 < n3) {
            CompoundType.Method method = methodArray[n15];
            String string = stringArray[n15];
            if (method.isAttribute()) {
                string = Constants.ATTRIBUTE_WIRE_PREFIX[method.getAttributeKind()] + IDLNames.stripLeadingUnderscore(string);
                String string2 = stringArray[n15];
                method.setAttributeName(string2);
            }
            method.setIDLName(string);
            ++n15;
        }
    }

    private static String stripLeadingUnderscore(String string) {
        if (string != null && string.length() > 1 && string.charAt(0) == '_') {
            return string.substring(1);
        }
        return string;
    }

    private static void convertOverloadedMethods(CompoundType.Method[] methodArray, String[] stringArray, boolean[] blArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (blArray[n2]) {
                CompoundType.Method method = methodArray[n2];
                Type[] typeArray = method.getArguments();
                int n3 = 0;
                while (n3 < typeArray.length) {
                    int n4 = n2;
                    stringArray[n4] = stringArray[n4] + "__";
                    String string = typeArray[n3].getQualifiedIDLName(false);
                    string = IDLNames.replace(string, "::_", "_");
                    string = IDLNames.replace(string, "::", "_");
                    string = IDLNames.replace(string, " ", "_");
                    int n5 = n2;
                    stringArray[n5] = stringArray[n5] + string;
                    ++n3;
                }
                if (typeArray.length == 0) {
                    int n6 = n2;
                    stringArray[n6] = stringArray[n6] + "__";
                }
                stringArray[n2] = IDLNames.stripLeadingUnderscore(stringArray[n2]);
            }
            ++n2;
        }
    }

    private static boolean doesMethodCollide(String string, CompoundType.Method method, CompoundType.Method[] methodArray, String[] stringArray, boolean bl2) {
        int n2 = 0;
        while (n2 < methodArray.length) {
            CompoundType.Method method2 = methodArray[n2];
            if (!(method == method2 || method2.isConstructor() || bl2 && method2.isAttribute() || !string.equals(stringArray[n2]))) {
                int n3 = method.getAttributeKind();
                int n4 = method2.getAttributeKind();
                if (!(n3 != 0 && n4 != 0 && (n3 == 5 && n4 != 5 || n3 != 5 && n4 == 5 || n3 == 3 && n4 == 2 || n3 == 2 && n4 == 3))) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean doesConstructorCollide(String string, CompoundType.Method method, CompoundType.Method[] methodArray, String[] stringArray, boolean bl2) {
        int n2 = 0;
        while (n2 < methodArray.length) {
            CompoundType.Method method2 = methodArray[n2];
            if (method != method2 && method2.isConstructor() == bl2 && string.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setMemberNames(CompoundType compoundType, CompoundType.Member[] memberArray, CompoundType.Method[] methodArray, BatchEnvironment batchEnvironment) throws Exception {
        boolean bl2;
        int n2;
        Object object;
        NameContext nameContext = new NameContext(true);
        int n3 = 0;
        while (n3 < memberArray.length) {
            nameContext.put(memberArray[n3].getName());
            ++n3;
        }
        int n4 = 0;
        while (n4 < memberArray.length) {
            object = memberArray[n4];
            String string = IDLNames.getMemberOrMethodName(nameContext, ((CompoundType.Member)object).getName(), batchEnvironment);
            ((CompoundType.Member)object).setIDLName(string);
            ++n4;
        }
        object = compoundType.getIDLName();
        int n5 = 0;
        while (n5 < memberArray.length) {
            String string = memberArray[n5].getIDLName();
            if (string.equalsIgnoreCase((String)object)) {
                memberArray[n5].setIDLName(string + "_");
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < memberArray.length) {
            String string = memberArray[n6].getIDLName();
            n2 = 0;
            while (n2 < memberArray.length) {
                if (n6 != n2 && memberArray[n2].getIDLName().equals(string)) {
                    throw new Exception(string);
                }
                ++n2;
            }
            ++n6;
        }
        do {
            bl2 = false;
            n2 = 0;
            while (n2 < memberArray.length) {
                String string = memberArray[n2].getIDLName();
                int n7 = 0;
                while (n7 < methodArray.length) {
                    if (methodArray[n7].getIDLName().equals(string)) {
                        memberArray[n2].setIDLName(string + "_");
                        bl2 = true;
                        break;
                    }
                    ++n7;
                }
                ++n2;
            }
        } while (bl2);
    }

    public static String getTypeName(int n2, boolean bl2) {
        String string = null;
        switch (n2) {
            case 1: {
                string = "void";
                break;
            }
            case 2: {
                string = "boolean";
                break;
            }
            case 4: {
                string = "octet";
                break;
            }
            case 8: {
                string = "wchar";
                break;
            }
            case 16: {
                string = "short";
                break;
            }
            case 32: {
                string = "long";
                break;
            }
            case 64: {
                string = "long long";
                break;
            }
            case 128: {
                string = "float";
                break;
            }
            case 256: {
                string = "double";
                break;
            }
            case 1024: {
                string = "any";
                break;
            }
            case 2048: {
                string = "Object";
                break;
            }
            case 512: {
                string = bl2 ? "wstring" : "WStringValue";
            }
        }
        return string;
    }

    public static String getQualifiedName(String[] stringArray, String string) {
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (n2 == 0) {
                    string2 = stringArray[0];
                } else {
                    string2 = string2 + "::";
                    string2 = string2 + stringArray[n2];
                }
                ++n2;
            }
            string2 = string2 + "::";
            string2 = string2 + string;
        } else {
            string2 = string;
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        int n2 = string.indexOf(string2, 0);
        if (n2 >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
            int n3 = string2.length();
            int n4 = 0;
            while (n2 >= 0) {
                stringBuffer.append(string.substring(n4, n2));
                stringBuffer.append(string3);
                n4 = n2 + n3;
                n2 = string.indexOf(string2, n4);
            }
            if (n4 < string.length()) {
                stringBuffer.append(string.substring(n4));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getIDLRepositoryID(String string) {
        return "IDL:" + IDLNames.replace(string, "::", "/") + ":1.0";
    }

    private static String getTypeOrModuleName(String string) {
        String string2 = IDLNames.convertLeadingUnderscores(string);
        return IDLNames.convertIDLKeywords(string2);
    }
}

