/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.tags.BaseTagSupport;

public class MakeRelativePathTag
extends BaseTagSupport {
    private File basedir;
    private String path;
    private String separator = null;
    private String var;

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        this.checkAttribute(this.basedir, "basedir");
        this.checkAttribute(this.path, "path");
        this.checkAttribute(this.var, "var");
        try {
            String canonicalPath = MavenUtils.makeRelativePath((File)this.basedir, (String)this.path);
            if (this.separator != null) {
                StringBuffer buf = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(canonicalPath, "/\\");
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(this.separator);
                }
                canonicalPath = buf.toString();
            }
            this.getContext().setVariable(this.var, (Object)canonicalPath);
        }
        catch (IOException e) {
            throw new JellyTagException("Unable to resolve directory", (Throwable)e);
        }
    }
}

