/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.jelly.tags.BaseTagSupport;
import org.apache.maven.project.Project;

public class SnapshotSignature
extends BaseTagSupport {
    private Project project;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException {
        this.checkAttribute(this.project, "project");
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String snapshotVersion = formatter.format(now);
        String snapshotSignature = this.getProject().getArtifactId() + "-" + snapshotVersion;
        this.context.setVariable("snapshotSignature", (Object)snapshotSignature);
        this.context.setVariable("snapshotVersion", (Object)snapshotVersion);
    }
}

