/*
 * Decompiled with CFR 0.152.
 */
package vdoclet;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import vdoclet.GeneratorException;

public class Generator {
    private static final Properties defaultVelocityProps = Generator.loadProperties("Generator-velocity.properties");
    private VelocityEngine _engine;
    private File _outputDir;
    private Context _context;
    static /* synthetic */ Class class$vdoclet$Generator;

    protected static Properties loadProperties(String resourceName) {
        Properties props = new Properties();
        try {
            InputStream inputStream = (class$vdoclet$Generator == null ? (class$vdoclet$Generator = Generator.class$("vdoclet.Generator")) : class$vdoclet$Generator).getResourceAsStream(resourceName);
            if (inputStream != null) {
                props.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("can't load " + resourceName);
        }
        return props;
    }

    public Generator(File outputDir) throws GeneratorException {
        this.initVelocityEngine();
        this._outputDir = outputDir;
        this._context = new VelocityContext();
        this.setAttribute("vdoclet", this);
    }

    private void initVelocityEngine() throws GeneratorException {
        try {
            this._engine = new VelocityEngine();
            this._engine.init(defaultVelocityProps);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
    }

    protected VelocityEngine getEngine() {
        return this._engine;
    }

    public File getOutputDir() {
        return this._outputDir;
    }

    protected FileWriter getFileWriter(String fileName) throws IOException {
        File file = new File(this.getOutputDir(), fileName);
        file.getParentFile().mkdirs();
        return new FileWriter(file);
    }

    public Context getContext() {
        return this._context;
    }

    public void setAttribute(String key, Object value) {
        this._context.put(key, value);
    }

    void merge(String templateName, Writer writer, Context context) throws IOException, GeneratorException {
        try {
            Template template = this.getEngine().getTemplate(templateName);
            template.merge(context, writer);
            writer.flush();
        }
        catch (IOException e) {
            throw e;
        }
        catch (GeneratorException e) {
            throw e;
        }
        catch (MethodInvocationException e) {
            Throwable cause = e.getWrappedThrowable();
            if (cause instanceof GeneratorException) {
                throw (GeneratorException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw new GeneratorException("error invoking $" + e.getReferenceName() + "." + e.getMethodName() + "() in \"" + templateName + "\"", cause);
        }
        catch (Exception e) {
            throw new GeneratorException("error parsing \"" + templateName + "\"", e);
        }
    }

    public void eval(String templateName, Writer writer) throws IOException, GeneratorException {
        this.merge(templateName, writer, this.getContext());
    }

    public void eval(String templateName, String fileName) throws IOException, GeneratorException {
        FileWriter writer = this.getFileWriter(fileName);
        this.eval(templateName, writer);
        writer.close();
    }

    public Object makeBean(String className) throws Exception {
        return Class.forName(className).newInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

