/*
 * Decompiled with CFR 0.152.
 */
package vdoclet;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import vdoclet.Generator;
import vdoclet.docinfo.DocInfo;
import vdoclet.docinfo.QDoxBuilder;

public class Main {
    File destDir;
    String template;
    String[] sourceFiles;
    String sourcePath;
    boolean verbose = false;
    DocInfo docInfo;

    public static void main(String[] args) throws Exception {
        new Main().execute(args);
    }

    public void execute(String[] args) throws Exception {
        this.parseCommandLine(args);
        this.validateCommandLine();
        this.parseSources();
        this.generate();
    }

    void log(String msg) {
        if (this.verbose) {
            System.err.println(msg);
        }
    }

    void parseCommandLine(String[] args) throws Exception {
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            if (args[i].equals("-d")) {
                this.destDir = new File(args[++i]);
            } else if (args[i].equals("-s")) {
                this.sourcePath = args[++i];
            } else if (args[i].equals("-t")) {
                this.template = args[++i];
            } else if (args[i].equals("-v")) {
                this.verbose = true;
            } else {
                throw new Exception("Illegal command-line arg: " + args[i]);
            }
            ++i;
        }
        int nFiles = args.length - i;
        this.sourceFiles = new String[nFiles];
        System.arraycopy(args, i, this.sourceFiles, 0, nFiles);
    }

    void validateCommandLine() throws Exception {
        if (this.destDir == null) {
            throw new Exception("missing -d argument");
        }
        if (this.template == null) {
            throw new Exception("missing -t argument");
        }
        if (this.sourceFiles.length == 0) {
            throw new Exception("no source-files provided");
        }
    }

    void parseSources() throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        ArrayList<File> sourceDirList = new ArrayList<File>();
        int i = 0;
        while (i < this.sourceFiles.length) {
            this.log("reading " + this.sourceFiles[i]);
            File f = new File(this.sourceFiles[i]);
            if (f.isDirectory()) {
                builder.addSourceTree(f);
                sourceDirList.add(f);
            } else {
                builder.addSource((Reader)new FileReader(f));
            }
            ++i;
        }
        JavaSource[] javaSources = builder.getSources();
        this.log(javaSources.length + " source-files");
        this.docInfo = QDoxBuilder.build(javaSources);
        if (this.sourcePath != null) {
            this.docInfo.setSourcePath(this.sourcePath);
        } else {
            String[] srcPath = sourceDirList.toArray(new String[0]);
            this.docInfo.setSourcePath(srcPath);
        }
    }

    void generate() throws Exception {
        Generator generator = new Generator(this.destDir);
        generator.setAttribute("docInfo", this.docInfo);
        generator.eval(this.template, new OutputStreamWriter(System.out));
    }
}

