/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.Path;

public class GeneratorTask
extends Task {
    private File destDir;
    private Path srcPath;
    private Path classPath;
    private String template;
    private boolean includePrivate = false;

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setClassPath(Path classPath) {
        if (this.classPath == null) {
            this.classPath = classPath;
        } else {
            this.classPath.append(classPath);
        }
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(((ProjectComponent)this).project);
        }
        return this.classPath.createPath();
    }

    public void setSrcDir(Path srcDir) {
        if (this.srcPath == null) {
            this.srcPath = srcDir;
        } else {
            this.srcPath.append(srcDir);
        }
    }

    public Path createSrcDir() {
        if (this.srcPath == null) {
            this.srcPath = new Path(((ProjectComponent)this).project);
        }
        return this.srcPath.createPath();
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setPrivate(boolean includePrivate) {
        this.includePrivate = includePrivate;
    }

    protected Javadoc createJavadocTask() throws BuildException {
        Javadoc javadoc = (Javadoc)((ProjectComponent)this).project.createTask("javadoc");
        javadoc.setTaskName(this.getTaskName());
        javadoc.setOwningTarget(this.getOwningTarget());
        javadoc.setDestdir(this.destDir);
        javadoc.setSourcepath(this.srcPath);
        javadoc.setClasspath(this.classPath);
        javadoc.setVerbose(false);
        javadoc.setFailonerror(true);
        javadoc.setPrivate(this.includePrivate);
        javadoc.setUseExternalFile(true);
        javadoc.setPackagenames("*.*");
        Javadoc.DocletInfo doclet = javadoc.createDoclet();
        doclet.setName("vdoclet.GeneratorDoclet");
        doclet.setPath(this.classPath);
        Javadoc.DocletParam param = doclet.createParam();
        param.setName("-c");
        param.setValue(this.template);
        return javadoc;
    }

    private void checkParams() throws BuildException {
        if (this.destDir == null) {
            this.complainAboutMissing("destDir");
        }
        if (this.srcPath == null) {
            this.complainAboutMissing("srcDir");
        }
        if (this.template == null) {
            this.complainAboutMissing("template");
        }
    }

    private void complainAboutMissing(String paramName) throws BuildException {
        throw new BuildException("no '" + paramName + "' provided", this.getLocation());
    }

    public void execute() throws BuildException {
        this.checkParams();
        this.createJavadocTask().execute();
    }
}

