/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.ant;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class VDocletTask
extends Task {
    private File destDir;
    private String template;
    private Path inputJavaFiles;
    private Path sourcePath;
    private Path classPath;

    public void setProject(Project project) {
        super.setProject(project);
        this.inputJavaFiles = new Path(project);
        this.sourcePath = new Path(project);
        this.classPath = new Path(project);
    }

    public void setSrcPath(Path srcPath) {
        this.inputJavaFiles.append(srcPath);
        this.sourcePath.append(srcPath);
    }

    public void setSrcDir(Path srcDir) {
        this.setSrcPath(srcDir);
    }

    public void addConfiguredFileSet(FileSet fileSet) {
        this.inputJavaFiles.addFileset(fileSet);
        File dir = fileSet.getDir(this.getProject());
        this.sourcePath.createPathElement().setLocation(dir);
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setClassPath(Path classPath) {
        classPath.append(classPath);
    }

    public Path createClassPath() {
        return this.classPath.createPath();
    }

    private void checkParams() throws BuildException {
        if (this.destDir == null) {
            this.complainAboutMissing("destDir");
        }
        if (this.template == null) {
            this.complainAboutMissing("template");
        }
    }

    private void complainAboutMissing(String paramName) throws BuildException {
        throw new BuildException("no '" + paramName + "' provided", this.getLocation());
    }

    Path getExecutionClassPath() {
        Path execPath = new Path(this.getProject());
        execPath.addExisting(this.classPath);
        try {
            AntClassLoader classLoader = (AntClassLoader)((Object)((Object)this)).getClass().getClassLoader();
            String taskPath = classLoader.getClasspath();
            this.log("taskPath: " + taskPath, 4);
            execPath.createPathElement().setPath(taskPath);
        }
        catch (ClassCastException e) {
            this.log("task ClassLoader is not an AntClassLoader", 0);
        }
        return execPath.concatSystemClasspath();
    }

    public void execute() throws BuildException {
        this.checkParams();
        Java javaTask = (Java)((ProjectComponent)this).project.createTask("java");
        javaTask.setTaskName(this.getTaskName());
        javaTask.setOwningTarget(this.getOwningTarget());
        javaTask.setFork(true);
        javaTask.setClassname("vdoclet.Main");
        javaTask.createArg().setValue("-d");
        javaTask.createArg().setFile(this.destDir);
        javaTask.createArg().setValue("-s");
        javaTask.createArg().setPath(this.sourcePath);
        javaTask.createArg().setValue("-t");
        javaTask.createArg().setValue(this.template);
        javaTask.setClasspath(this.getExecutionClassPath());
        String[] sources = this.inputJavaFiles.list();
        int i = 0;
        while (i < sources.length) {
            javaTask.createArg().setValue(sources[i]);
            ++i;
        }
        javaTask.execute();
    }
}

