/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlCheckTask
extends Task {
    private List filesets = new ArrayList();
    private Map dtdCatalog = new HashMap();
    private SAXParser parser = null;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addConfiguredDTD(DTDLocation dtdLocation) {
        try {
            this.log("adding DTD: id='" + dtdLocation.getPublicId() + "'; location='" + dtdLocation.getLocation() + "'", 3);
            this.dtdCatalog.put(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void execute() throws BuildException {
        this.checkParams();
        this.initParser();
        this.validateFiles();
    }

    private void checkParams() throws BuildException {
        if (this.filesets.isEmpty()) {
            throw new BuildException("No files to check");
        }
    }

    private void initParser() throws BuildException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void validateFile(File file) throws BuildException {
        if (!file.isFile() || !file.canRead()) {
            throw new BuildException("can't read file '" + file + "'");
        }
        this.log("validating: " + file, 3);
        CheckHandler fileChecker = new CheckHandler();
        try {
            this.parser.parse(file, (DefaultHandler)fileChecker);
        }
        catch (SAXParseException e) {
            this.log(this.getMessage(e), 0);
            throw new BuildException("failed to validate: " + file, (Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException("failed to validate: " + file, (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void validateFiles() throws BuildException {
        Iterator fi = this.filesets.iterator();
        while (fi.hasNext()) {
            FileSet fileset = (FileSet)fi.next();
            String[] files = fileset.getDirectoryScanner(((ProjectComponent)this).project).getIncludedFiles();
            int j = 0;
            while (j < files.length) {
                File file = new File(fileset.getDir(((ProjectComponent)this).project), files[j]);
                this.validateFile(file);
                ++j;
            }
        }
    }

    private String getMessage(SAXParseException e) {
        StringBuffer msg = new StringBuffer();
        if (e.getSystemId() != null && e.getSystemId().startsWith("file:")) {
            msg.append(e.getSystemId().substring(5));
            msg.append(':');
            if (e.getLineNumber() != -1) {
                msg.append(e.getLineNumber());
                msg.append(':');
            }
            if (e.getColumnNumber() != -1) {
                msg.append(e.getColumnNumber());
                msg.append(':');
            }
            msg.append(' ');
        }
        msg.append(e.getMessage());
        return msg.toString();
    }

    protected class CheckHandler
    extends DefaultHandler {
        protected CheckHandler() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (XmlCheckTask.this.dtdCatalog.containsKey(publicId)) {
                URL dtdURL = (URL)XmlCheckTask.this.dtdCatalog.get(publicId);
                try {
                    return new InputSource(dtdURL.openStream());
                }
                catch (IOException e) {
                    throw new SAXException("can't open " + dtdURL, e);
                }
            }
            return null;
        }

        public void fatalError(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }
    }

    public static class DTDLocation {
        private String publicId = null;
        private String location = null;

        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public URL getLocation() throws MalformedURLException {
            File dtdFile = new File(this.location);
            if (dtdFile.exists()) {
                return dtdFile.toURL();
            }
            URL dtdResource = this.getClass().getResource(this.location);
            if (dtdResource != null) {
                return dtdResource;
            }
            return new URL(this.location);
        }
    }
}

