/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.beaninfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import vdoclet.docinfo.FieldInfo;
import vdoclet.docinfo.MethodInfo;
import vdoclet.util.StringUtils;

public class PropertyInfo
extends FieldInfo {
    private final MethodInfo _getter;
    private final MethodInfo _setter;

    public PropertyInfo(String type, String name, MethodInfo getter, MethodInfo setter) {
        super(type, name);
        this._getter = getter;
        this._setter = setter;
    }

    public static PropertyInfo fromField(String type, String name) {
        return new PropertyInfo(type, name, PropertyInfo.makeGetter(type, name), PropertyInfo.makeSetter(type, name));
    }

    private static MethodInfo makeSetter(String type, String name) {
        MethodInfo setter = new MethodInfo("void", "set" + StringUtils.capitalise(name));
        setter.addParameter(type, name);
        return setter;
    }

    private static MethodInfo makeGetter(String type, String name) {
        String prefix = type.equals("boolean") ? "is" : "get";
        return new MethodInfo(type, prefix + StringUtils.capitalise(name));
    }

    public static PropertyInfo fromGetter(MethodInfo getter) {
        String name;
        if (getter.getName().startsWith("get")) {
            name = StringUtils.stripPrefix("get", getter.getName());
        } else if (getter.getName().startsWith("is")) {
            name = StringUtils.stripPrefix("is", getter.getName());
        } else {
            throw new IllegalArgumentException("Can't derive a field from " + getter.getName() + "(): " + "bad name");
        }
        if (!getter.getParameters().isEmpty()) {
            throw new IllegalArgumentException("Can't derive a field from " + getter.getName() + "(): " + "getters cannot have parameters");
        }
        return new PropertyInfo(getter.getType(), name, getter, PropertyInfo.makeSetter(getter.getType(), name));
    }

    public MethodInfo getGetter() {
        return this._getter;
    }

    public MethodInfo getSetter() {
        return this._setter;
    }

    public List getTags(String name) {
        ArrayList tags = new ArrayList();
        tags.addAll(super.getTags(name));
        if (this.getGetter() != null) {
            tags.addAll(this.getGetter().getTags(name));
        }
        return Collections.unmodifiableList(tags);
    }
}

