/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.docinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import vdoclet.docinfo.TagInfo;

public abstract class BaseInfo
implements Cloneable {
    private String name;
    private String comment;
    private ArrayList tags = new ArrayList();

    public BaseInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void ex;
            BaseInfo clone = (BaseInfo)super.clone();
            clone.tags = (ArrayList)this.tags.clone();
            return ex;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void addTag(TagInfo tag) {
        this.tags.add(tag);
    }

    public void addTag(String name, String value) {
        this.addTag(new TagInfo(name, value));
    }

    public void addTags(Collection tags) {
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            this.addTag((TagInfo)i.next());
        }
    }

    public List getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public List getTags(String name) {
        Iterator i = this.getTags().iterator();
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
        while (i.hasNext()) {
            TagInfo tag = (TagInfo)i.next();
            if (!tag.getName().equals(name)) continue;
            tags.add(tag);
        }
        return Collections.unmodifiableList(tags);
    }

    public TagInfo getTag(String name) {
        List tags = this.getTags(name);
        return tags.isEmpty() ? null : (TagInfo)tags.get(0);
    }

    public String getTagValue(String name) {
        TagInfo tag = this.getTag(name);
        return tag == null ? null : tag.getValue();
    }

    public String getTagValue(String name, String defaultValue) {
        String value = this.getTagValue(name);
        return value == null ? defaultValue : value;
    }
}

