/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.docinfo;

import vdoclet.docinfo.BaseElementInfo;
import vdoclet.docinfo.BaseInfo;
import vdoclet.docinfo.ClassInfo;
import vdoclet.docinfo.DocInfo;
import vdoclet.docinfo.FieldInfo;
import vdoclet.docinfo.MethodInfo;

public class Builder {
    DocInfo docInfo = new DocInfo();
    String currPackage;
    BaseInfo currInfo;
    BaseElementInfo currElement;
    ClassInfo currClass;
    MethodInfo currMethod;

    public DocInfo getDocInfo() {
        return this.docInfo;
    }

    public void setPackage(String pkg) {
        this.currPackage = pkg;
    }

    public ClassInfo addClass(String name) {
        ClassInfo clazz = new ClassInfo(name);
        this.docInfo.addClass(clazz);
        this.currClass = clazz;
        this.currElement = this.currClass;
        this.currInfo = this.currClass;
        this.currMethod = null;
        return clazz;
    }

    public void setComment(String comment) {
        if (this.currInfo == null) {
            throw new IllegalStateException("no BaseInfo");
        }
        if (comment == null || comment.length() == 0) {
            return;
        }
        this.currInfo.setComment(comment);
    }

    public void addTag(String name, String value) {
        if (this.currInfo == null) {
            throw new IllegalStateException("no BaseInfo");
        }
        this.currInfo.addTag(name, value);
    }

    public void setPublic(boolean isPublic) {
        if (this.currElement == null) {
            throw new IllegalStateException("no BaseElementInfo");
        }
        this.currElement.setPublic(isPublic);
    }

    public void setPrivate(boolean isPrivate) {
        if (this.currElement == null) {
            throw new IllegalStateException("no BaseElementInfo");
        }
        this.currElement.setPrivate(isPrivate);
    }

    public void setProtected(boolean isProtected) {
        if (this.currElement == null) {
            throw new IllegalStateException("no BaseElementInfo");
        }
        this.currElement.setProtected(isProtected);
    }

    public void setStatic(boolean isStatic) {
        if (this.currElement == null) {
            throw new IllegalStateException("no BaseElementInfo");
        }
        this.currElement.setStatic(isStatic);
    }

    public void setFinal(boolean isFinal) {
        if (this.currElement == null) {
            throw new IllegalStateException("no BaseElementInfo");
        }
        this.currElement.setFinal(isFinal);
    }

    public void setAbstract(boolean isAbstract) {
        if (this.currElement == null) {
            throw new IllegalStateException("no BaseElementInfo");
        }
        this.currElement.setAbstract(isAbstract);
    }

    public MethodInfo addMethod(String type, String name) {
        if (this.currClass == null) {
            throw new IllegalStateException("no ClassInfo");
        }
        MethodInfo method = new MethodInfo(this.qualifyType(type), name);
        this.currClass.addMethod(method);
        this.currMethod = method;
        this.currElement = this.currMethod;
        this.currInfo = this.currMethod;
        return method;
    }

    public void setSuperClass(String superClass) {
        if (this.currClass == null) {
            throw new IllegalStateException("no ClassInfo");
        }
        this.currClass.setSuperClass(superClass);
    }

    public void addInterface(String iface) {
        if (this.currClass == null) {
            throw new IllegalStateException("no ClassInfo");
        }
        this.currClass.addInterface(iface);
    }

    public FieldInfo addField(String type, String name) {
        if (this.currClass == null) {
            throw new IllegalStateException("no ClassInfo");
        }
        FieldInfo field = new FieldInfo(this.qualifyType(type), name);
        this.currClass.addField(field);
        this.currElement = field;
        this.currInfo = this.currElement;
        return field;
    }

    public void addParameter(String type, String name) {
        if (this.currMethod == null) {
            throw new IllegalStateException("no MethodInfo");
        }
        this.currMethod.addParameter(this.qualifyType(type), name);
    }

    public void addException(String exception) {
        if (this.currMethod == null) {
            throw new IllegalStateException("no MethodInfo");
        }
        this.currMethod.addException(exception);
    }

    private String qualifyType(String typeName) {
        if (typeName.indexOf(".") != -1 || Character.getType(typeName.charAt(0)) == 2) {
            return typeName;
        }
        if (this.currPackage != null) {
            typeName = this.currPackage + '.' + typeName;
        }
        return typeName;
    }
}

