/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.docinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import vdoclet.docinfo.BaseElementInfo;
import vdoclet.docinfo.DocInfo;
import vdoclet.docinfo.FieldInfo;
import vdoclet.docinfo.MethodInfo;
import vdoclet.util.DelimitedList;

public class ClassInfo
extends BaseElementInfo {
    private DocInfo docInfo;
    private final List methods = new ArrayList();
    private final List fields = new ArrayList();
    private String superClassName = "java.lang.Object";
    private final List interfaces = new ArrayList();

    public ClassInfo(String name) {
        super(name);
    }

    public void setContainingDocInfo(DocInfo docInfo) {
        this.docInfo = docInfo;
    }

    public DocInfo getContainingDocInfo() {
        return this.docInfo;
    }

    public String getName() {
        return super.getName();
    }

    public String getPackage() {
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return this.getName().substring(0, lastDot);
    }

    public String getShortName() {
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot == -1) {
            return this.getName();
        }
        return this.getName().substring(lastDot + 1);
    }

    public void addField(FieldInfo field) {
        this.fields.add(field);
        field.setContainingClass(this);
    }

    public void addFields(Collection fields) {
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            this.addField((FieldInfo)i.next());
        }
    }

    public List getFields() {
        return new DelimitedList(this.fields, ", ");
    }

    public FieldInfo getField(int index) {
        return (FieldInfo)this.getFields().get(index);
    }

    public void addMethod(MethodInfo method) {
        this.methods.add(method);
        method.setContainingClass(this);
    }

    public void addMethods(Collection methods) {
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            this.addMethod((MethodInfo)i.next());
        }
    }

    public List getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public MethodInfo getMethod(int index) {
        return (MethodInfo)this.getMethods().get(index);
    }

    public MethodInfo getMethod(String name, List types) {
        Iterator i = this.getMethods().iterator();
        while (i.hasNext()) {
            MethodInfo method = (MethodInfo)i.next();
            if (!method.getName().equals(name) || !method.getParameterTypes().equals(types)) continue;
            return method;
        }
        return null;
    }

    public void setSuperClass(String superClassName) {
        this.superClassName = superClassName;
    }

    public String getSuperClass() {
        return this.superClassName;
    }

    public ClassInfo resolveSuperClass() {
        if (this.getSuperClass() == null) {
            return null;
        }
        if (this.getContainingDocInfo() == null) {
            return null;
        }
        return this.getContainingDocInfo().getClass(this.getSuperClass());
    }

    public void addInterface(String iface) {
        this.interfaces.add(iface);
    }

    public void addInterfaces(Collection interfaces) {
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            this.addInterface((String)i.next());
        }
    }

    public Collection getInterfaces() {
        return new DelimitedList(this.interfaces, ", ");
    }

    public boolean hasInterface(String name) {
        ClassInfo superClass = this.resolveSuperClass();
        if (this.interfaces.contains(name)) {
            return true;
        }
        if (superClass != null) {
            return superClass.hasInterface(name);
        }
        return false;
    }
}

