/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.docinfo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import vdoclet.docinfo.ClassInfo;

public class DocInfo {
    private final Map classMap = new TreeMap();
    private String[] sourcePath = new String[0];

    public void addClass(ClassInfo classInfo) {
        this.classMap.put(classInfo.getName(), classInfo);
        classInfo.setContainingDocInfo(this);
    }

    public Collection getClasses() {
        return this.classMap.values();
    }

    public ClassInfo getClass(String name) {
        return (ClassInfo)this.classMap.get(name);
    }

    public ClassInfo makeClass(String name) {
        ClassInfo clazz = new ClassInfo(name);
        this.addClass(clazz);
        return clazz;
    }

    public void setSourcePath(String[] sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setSourcePath(String path) {
        StringTokenizer tokens = new StringTokenizer(path, File.pathSeparator);
        ArrayList<String> sourceDirList = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            sourceDirList.add(tokens.nextToken());
        }
        String[] newSourcePath = new String[sourceDirList.size()];
        this.setSourcePath(sourceDirList.toArray(newSourcePath));
    }

    public File getSourceFile(String name) {
        int i = 0;
        while (i < this.sourcePath.length) {
            File file = new File(this.sourcePath[i], name);
            if (file.exists()) {
                return file;
            }
            ++i;
        }
        return null;
    }
}

