/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.docinfo;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import vdoclet.docinfo.Builder;
import vdoclet.docinfo.DocInfo;

public class JavadocBuilder
extends Builder {
    public static DocInfo build(RootDoc rootDoc) {
        JavadocBuilder builder = new JavadocBuilder();
        builder.processRoot(rootDoc);
        return builder.getDocInfo();
    }

    public void processRoot(RootDoc rootDoc) {
        ClassDoc[] classes = rootDoc.classes();
        int i = 0;
        while (i < classes.length) {
            this.processClass(classes[i]);
            ++i;
        }
    }

    private void processDoc(Doc doc) {
        this.setComment(doc.commentText());
        Tag[] tags = doc.tags();
        int i = 0;
        while (i < tags.length) {
            this.addTag(tags[i].name(), tags[i].text());
            ++i;
        }
    }

    private void processProgramElement(ProgramElementDoc progElt) {
        this.processDoc((Doc)progElt);
        this.setPublic(progElt.isPublic());
        this.setProtected(progElt.isProtected());
        this.setPrivate(progElt.isPrivate());
        this.setStatic(progElt.isStatic());
        this.setFinal(progElt.isFinal());
    }

    public void processClass(ClassDoc classDoc) {
        this.addClass(classDoc.qualifiedName());
        this.processProgramElement((ProgramElementDoc)classDoc);
        this.setAbstract(classDoc.isAbstract());
        if (classDoc.superclass() != null) {
            this.setSuperClass(classDoc.superclass().qualifiedName());
        }
        FieldDoc[] fieldDocs = classDoc.fields();
        int i = 0;
        while (i < fieldDocs.length) {
            this.processField(fieldDocs[i], classDoc);
            ++i;
        }
        MethodDoc[] methodDocs = classDoc.methods();
        int i2 = 0;
        while (i2 < methodDocs.length) {
            this.processMethod(methodDocs[i2], classDoc);
            ++i2;
        }
        ClassDoc[] interfaces = classDoc.interfaces();
        int i3 = 0;
        while (i3 < interfaces.length) {
            this.addInterface(interfaces[i3].qualifiedName());
            ++i3;
        }
    }

    private static String getPackageName(ClassDoc classDoc) {
        while (classDoc.containingClass() != null) {
            classDoc = classDoc.containingClass();
        }
        String className = classDoc.qualifiedName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return className.substring(0, lastDot);
    }

    private static String getTypeName(Type type, ClassDoc contextClassDoc) {
        String typeName = type.qualifiedTypeName();
        if (typeName.indexOf(".") != -1 || Character.getType(typeName.charAt(0)) == 2) {
            return typeName;
        }
        String packageName = JavadocBuilder.getPackageName(contextClassDoc);
        if (packageName != null) {
            typeName = packageName + '.' + typeName;
        }
        return typeName;
    }

    public void processMethod(MethodDoc methodDoc, ClassDoc classDoc) {
        this.addMethod(JavadocBuilder.getTypeName(methodDoc.returnType(), classDoc), methodDoc.name());
        this.processProgramElement((ProgramElementDoc)methodDoc);
        Parameter[] parameters = methodDoc.parameters();
        int i = 0;
        while (i < parameters.length) {
            this.addParameter(JavadocBuilder.getTypeName(parameters[i].type(), classDoc), parameters[i].name());
            ++i;
        }
        ClassDoc[] exceptions = methodDoc.thrownExceptions();
        int i2 = 0;
        while (i2 < exceptions.length) {
            this.addException(exceptions[i2].qualifiedName());
            ++i2;
        }
    }

    public void processField(FieldDoc fieldDoc, ClassDoc classDoc) {
        this.addField(JavadocBuilder.getTypeName(fieldDoc.type(), classDoc), fieldDoc.name());
        this.processProgramElement((ProgramElementDoc)fieldDoc);
    }
}

