/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.docinfo;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import vdoclet.docinfo.Builder;
import vdoclet.docinfo.DocInfo;

public class QDoxBuilder
extends Builder {
    public static DocInfo build(JavaSource[] javaSources) {
        QDoxBuilder builder = new QDoxBuilder();
        int i = 0;
        while (i < javaSources.length) {
            builder.processJavaSource(javaSources[i]);
            ++i;
        }
        return builder.getDocInfo();
    }

    public void processJavaSource(JavaSource javaSource) {
        JavaClass[] classes = javaSource.getClasses();
        int i = 0;
        while (i < classes.length) {
            this.setPackage(javaSource.getPackage());
            this.processJavaClass(classes[i]);
            ++i;
        }
    }

    void processJavaEntity(AbstractJavaEntity javaEntity) {
        this.setComment(javaEntity.getComment());
        DocletTag[] tags = javaEntity.getTags();
        int i = 0;
        while (i < tags.length) {
            this.addTag("@" + tags[i].getName(), tags[i].getValue());
            ++i;
        }
        this.setPublic(javaEntity.isPublic());
        this.setProtected(javaEntity.isProtected());
        this.setPrivate(javaEntity.isPrivate());
        this.setStatic(javaEntity.isStatic());
        this.setFinal(javaEntity.isFinal());
    }

    void processJavaClass(JavaClass javaClass) {
        this.addClass(javaClass.getFullyQualifiedName());
        this.processJavaEntity((AbstractJavaEntity)javaClass);
        this.setAbstract(javaClass.isAbstract());
        if (javaClass.getSuperClass() != null) {
            this.setSuperClass(javaClass.getSuperClass().getValue());
        }
        Type[] interfaces = javaClass.getImplements();
        int i = 0;
        while (i < interfaces.length) {
            this.addInterface(interfaces[i].getValue());
            ++i;
        }
        JavaField[] fields = javaClass.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            this.processJavaField(fields[i2]);
            ++i2;
        }
        JavaMethod[] methods = javaClass.getMethods();
        int i3 = 0;
        while (i3 < methods.length) {
            this.processJavaMethod(methods[i3]);
            ++i3;
        }
        JavaClass[] classes = javaClass.getClasses();
        int i4 = 0;
        while (i4 < classes.length) {
            this.processJavaClass(classes[i4]);
            ++i4;
        }
    }

    void processJavaMethod(JavaMethod javaMethod) {
        if (javaMethod.isConstructor()) {
            return;
        }
        this.addMethod(javaMethod.getReturns().getValue(), javaMethod.getName());
        this.processJavaEntity((AbstractJavaEntity)javaMethod);
        JavaParameter[] parameters = javaMethod.getParameters();
        int i = 0;
        while (i < parameters.length) {
            this.addParameter(parameters[i].getType().getValue(), parameters[i].getName());
            ++i;
        }
        Type[] exceptions = javaMethod.getExceptions();
        int i2 = 0;
        while (i2 < exceptions.length) {
            this.addException(exceptions[i2].getValue());
            ++i2;
        }
    }

    void processJavaField(JavaField javaField) {
        this.addField(javaField.getType().getValue(), javaField.getName());
        this.processJavaEntity((AbstractJavaEntity)javaField);
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSourceTree(new File(args[0]));
        long end = System.currentTimeMillis();
        System.out.println("parsing took " + (end - start) + "ms");
        JavaSource[] javaSources = builder.getSources();
        int s = 0;
        while (s < javaSources.length) {
            JavaClass[] javaClasses = javaSources[s].getClasses();
            int c = 0;
            while (c < javaClasses.length) {
                System.out.println("CLASS " + javaClasses[c].getFullyQualifiedName());
                String[] mods = javaClasses[c].getModifiers();
                int m = 0;
                while (m < mods.length) {
                    System.out.println("  MOD " + mods[m]);
                    ++m;
                }
                DocletTag[] tags = javaClasses[c].getTags();
                int t = 0;
                while (t < tags.length) {
                    System.out.println("  TAG " + tags[t].getName() + " " + tags[t].getValue());
                    ++t;
                }
                ++c;
            }
            ++s;
        }
        start = System.currentTimeMillis();
        QDoxBuilder.build(javaSources);
        end = System.currentTimeMillis();
        System.out.println("bridging " + javaSources.length + " sources took " + (end - start) + "ms");
    }
}

