/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.ejb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import vdoclet.docinfo.ClassInfo;
import vdoclet.docinfo.DocInfo;
import vdoclet.docinfo.FieldInfo;
import vdoclet.ejb.EjbInfo;
import vdoclet.ejb.EjbRelation;
import vdoclet.ejb.EjbRelationRole;

public class EjbBundle {
    public static final String EJB_PROP_FILE = "vdoclet-ejb.properties";
    public static final String SECURITY_ROLES_PROP = "security.roles";
    public static final String EJB_VERSION_PROP = "ejb.version";
    protected static final EjbBundle NULL_BUNDLE = new EjbBundle(new DocInfo());
    private DocInfo _docInfo;
    private Map _ejbMap;
    private Map _abstractEjbMap;
    private Map _relationMap;
    private Properties _props = new Properties();

    public EjbBundle(DocInfo docInfo) {
        this._docInfo = docInfo;
        this.loadProperties();
    }

    private void loadProperties() {
        File propFile = this._docInfo.getSourceFile(EJB_PROP_FILE);
        if (propFile != null) {
            try {
                FileInputStream propStream = new FileInputStream(propFile);
                this._props.load(new BufferedInputStream(propStream));
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    void setProperty(String name, String value) {
        this._props.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this._props.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this._props.getProperty(name, defaultValue);
    }

    public Properties getPropertiesStartingWith(String prefix) {
        prefix = prefix + '.';
        Iterator iter = ((Hashtable)this._props).keySet().iterator();
        Properties matching = new Properties();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            String newKey = key.substring(prefix.length());
            matching.setProperty(newKey, this._props.getProperty(key));
        }
        return matching;
    }

    public float getEjbVersion() {
        return Float.parseFloat(this.getProperty(EJB_VERSION_PROP, "1.1"));
    }

    public Set getSecurityRoles() {
        TreeSet<String> roles = new TreeSet<String>();
        String rolesString = this._props.getProperty(SECURITY_ROLES_PROP, "");
        StringTokenizer tokens = new StringTokenizer(rolesString, ", ");
        while (tokens.hasMoreTokens()) {
            roles.add(tokens.nextToken());
        }
        return roles;
    }

    public DocInfo getDocInfo() {
        return this._docInfo;
    }

    private void generateEjbs() {
        this._ejbMap = new TreeMap();
        this._abstractEjbMap = new TreeMap();
        Iterator i = this._docInfo.getClasses().iterator();
        while (i.hasNext()) {
            ClassInfo srcClass = (ClassInfo)i.next();
            EjbInfo ejb = new EjbInfo(srcClass);
            ejb.setBundle(this);
            if (ejb.isEjb()) {
                this._ejbMap.put(srcClass.getName(), ejb);
                continue;
            }
            if (!ejb.isAbstract()) continue;
            this._abstractEjbMap.put(srcClass.getName(), ejb);
        }
    }

    private void checkGenerateEjbs() {
        if (this._ejbMap == null) {
            this.generateEjbs();
        }
    }

    public Collection getEjbs() {
        this.checkGenerateEjbs();
        return Collections.unmodifiableCollection(this._ejbMap.values());
    }

    public Collection getAbstractEjbs() {
        this.checkGenerateEjbs();
        return Collections.unmodifiableCollection(this._abstractEjbMap.values());
    }

    public EjbInfo getEjb(String name) {
        this.checkGenerateEjbs();
        EjbInfo ejb = (EjbInfo)this._ejbMap.get(name);
        if (ejb == null) {
            ejb = (EjbInfo)this._abstractEjbMap.get(name);
        }
        return ejb;
    }

    private void generateRelations() {
        this._relationMap = new TreeMap();
        Iterator ejbIterator = this.getEjbs().iterator();
        while (ejbIterator.hasNext()) {
            EjbInfo ejb = (EjbInfo)ejbIterator.next();
            if (!ejb.isCmpEntity()) continue;
            Iterator cmrIterator = ejb.getCmrFields().iterator();
            while (cmrIterator.hasNext()) {
                EjbRelation relation;
                FieldInfo cmrField = (FieldInfo)cmrIterator.next();
                EjbRelationRole ejbRole = new EjbRelationRole(ejb, cmrField);
                String targetName = cmrField.getTag("@ejb-cmr-target").getWord(0);
                EjbInfo targetEjb = this.getEjb(targetName);
                if (targetEjb == null) {
                    targetEjb = new EjbInfo(new ClassInfo(targetName));
                }
                EjbRelationRole targetRole = new EjbRelationRole(targetEjb);
                String targetFieldName = cmrField.getTag("@ejb-cmr-target").getWord(1);
                if (targetFieldName != null) {
                    FieldInfo targetField = new FieldInfo("java.lang.Object", targetFieldName);
                    targetRole.setField(targetField);
                }
                if (this._relationMap.containsKey((relation = new EjbRelation(ejbRole, targetRole)).getName())) {
                    relation = (EjbRelation)this._relationMap.get(relation.getName());
                    relation.getRole(ejbRole.getName()).setField(cmrField);
                    continue;
                }
                this._relationMap.put(relation.getName(), relation);
            }
        }
    }

    private void checkGenerateRelations() {
        if (this._relationMap == null) {
            this.generateRelations();
        }
    }

    public Collection getRelations() {
        this.checkGenerateRelations();
        return Collections.unmodifiableCollection(this._relationMap.values());
    }
}

