/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.ejb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import vdoclet.beaninfo.PropertyInfo;
import vdoclet.docinfo.ClassInfo;
import vdoclet.docinfo.MethodInfo;
import vdoclet.docinfo.TagInfo;
import vdoclet.ejb.EjbBundle;
import vdoclet.ejb.EjbInfoException;
import vdoclet.ejb.EjbLocalView;
import vdoclet.ejb.EjbRemoteView;
import vdoclet.util.DelimitedList;
import vdoclet.util.StringUtils;

public class EjbInfo {
    private ClassInfo _srcClass;
    private EjbBundle _bundle = EjbBundle.NULL_BUNDLE;

    public EjbInfo(ClassInfo srcClass) {
        this._srcClass = srcClass;
    }

    public void setBundle(EjbBundle bundle) {
        this._bundle = bundle;
    }

    public EjbBundle getBundle() {
        return this._bundle;
    }

    public ClassInfo getSrcClass() {
        return this._srcClass;
    }

    public ClassInfo getSrcCmpInnerClass() {
        String innerClassName = this.getSrcClass().getName() + ".CMP";
        return this.getBundle().getDocInfo().getClass(innerClassName);
    }

    public List getAllSrcMethods() {
        ArrayList methods = new ArrayList();
        methods.addAll(this.getSrcClass().getMethods());
        if (this.getSrcCmpInnerClass() != null) {
            methods.addAll(this.getSrcCmpInnerClass().getMethods());
        }
        return methods;
    }

    public EjbInfo getSuperEjb() {
        ClassInfo superSrcClass = this.getSrcClass().resolveSuperClass();
        if (superSrcClass == null) {
            return null;
        }
        return this.getBundle().getEjb(superSrcClass.getName());
    }

    public String getTagValue(String name, String defaultValue) {
        defaultValue = this.getBundle().getProperty(name, defaultValue);
        return this.getSrcClass().getTagValue(name, defaultValue);
    }

    public String getTagValue(String name) {
        return this.getTagValue(name, null);
    }

    public List getTags(String name) {
        return this.getSrcClass().getTags(name);
    }

    public boolean isEjb() {
        return this.getType() != null;
    }

    public boolean isEntity() {
        return this.getTagValue("@ejb-entity") != null;
    }

    public boolean isSession() {
        return this.getTagValue("@ejb-session") != null;
    }

    public boolean isMessageDriven() {
        return this.getTagValue("@ejb-mdb") != null;
    }

    public boolean isCmpEntity() {
        String pType = this.getTagValue("@ejb-persistence-type", "Container");
        return this.isEntity() && pType.equals("Container");
    }

    public boolean isAbstract() {
        return this.getTagValue("@ejb-abstract") != null;
    }

    public String getType() {
        if (this.isEntity()) {
            return "entity";
        }
        if (this.isSession()) {
            return "session";
        }
        if (this.isMessageDriven()) {
            return "message-driven";
        }
        return null;
    }

    public String getBaseName() {
        String prefix = this.getTagValue("@ejb-base-name");
        if (prefix == null && (prefix = this.getSrcClass().getName()).endsWith("Bean")) {
            prefix = prefix.substring(0, prefix.length() - 4);
        }
        return prefix;
    }

    public String getName() {
        return this.getTagValue("@ejb-name", EjbInfo.shortName(this.getBaseName()));
    }

    String getPrimaryKeyClassName() {
        return this.getTagValue("@ejb-key-class", this.getBaseName() + "Key");
    }

    public boolean isPrimaryKeyRequired() {
        return this.getTagValue("@ejb-key-generate") != null;
    }

    public List getPrimaryKeyFields() {
        ArrayList<PropertyInfo> keyFields = new ArrayList<PropertyInfo>();
        Iterator i = this.getTags("@ejb-key-field").iterator();
        while (i.hasNext()) {
            TagInfo tag = (TagInfo)i.next();
            keyFields.add(PropertyInfo.fromField(tag.getWord(0), tag.getWord(1)));
        }
        Iterator i2 = this.getSrcClass().getMethods().iterator();
        while (i2.hasNext()) {
            MethodInfo method = (MethodInfo)i2.next();
            if (method.getTagValue("@ejb-key-field") == null) continue;
            PropertyInfo keyProperty = PropertyInfo.fromGetter(method);
            keyFields.add(keyProperty);
        }
        return new DelimitedList(keyFields, ", ");
    }

    public ClassInfo getPrimaryKey() {
        ClassInfo key = new ClassInfo(this.getPrimaryKeyClassName());
        if (this.isPrimaryKeyRequired()) {
            List keyFields = this.getPrimaryKeyFields();
            if (keyFields.isEmpty()) {
                throw new EjbInfoException("there are no @ejb-key-field tags in " + this.getSrcClass().getName());
            }
            key.addFields(keyFields);
        }
        return key;
    }

    public Collection getQueryMethods() {
        ArrayList<MethodInfo> queryMethods = new ArrayList<MethodInfo>();
        Iterator i = this.getAllSrcMethods().iterator();
        while (i.hasNext()) {
            MethodInfo queryMethod = (MethodInfo)i.next();
            if (queryMethod.getName().startsWith("ejbFind")) {
                queryMethod = (MethodInfo)queryMethod.clone();
                queryMethod.setName(StringUtils.stripPrefix("ejb", queryMethod.getName()));
            } else if (!queryMethod.getName().startsWith("ejbSelect")) continue;
            queryMethods.add(queryMethod);
        }
        return queryMethods;
    }

    public EjbRemoteView getRemoteView() {
        if (this.getBundle().getEjbVersion() >= 2.0f && this.getTagValue("@ejb-remote") == null) {
            return null;
        }
        return new EjbRemoteView(this);
    }

    public EjbLocalView getLocalView() {
        if (this.getTagValue("@ejb-local") == null) {
            return null;
        }
        return new EjbLocalView(this);
    }

    public String getCmp11ClassName() {
        return this.getTagValue("@ejb-cmp11-class", this.getBaseName() + "Cmp11");
    }

    public ClassInfo getCmp11Class() {
        if (!this.isCmpEntity()) {
            return null;
        }
        if (this.getBundle().getEjbVersion() >= 2.0f) {
            return null;
        }
        return new ClassInfo(this.getCmp11ClassName());
    }

    public List getCmpFields() {
        ArrayList<PropertyInfo> fields = new ArrayList<PropertyInfo>();
        Iterator i = this.getSrcClass().getMethods().iterator();
        while (i.hasNext()) {
            MethodInfo method = (MethodInfo)i.next();
            if (method.getTagValue("@ejb-cmp-column") == null) continue;
            fields.add(PropertyInfo.fromGetter(method));
        }
        return fields;
    }

    public List getCmrFields() {
        ArrayList<PropertyInfo> fields = new ArrayList<PropertyInfo>();
        Iterator i = this.getSrcClass().getMethods().iterator();
        while (i.hasNext()) {
            MethodInfo method = (MethodInfo)i.next();
            if (method.getTagValue("@ejb-cmr-target") == null) continue;
            fields.add(PropertyInfo.fromGetter(method));
        }
        return fields;
    }

    public String getCmpSchemaName() {
        return this.getTagValue("@ejb-cmp-schema-name", EjbInfo.shortName(this.getBaseName()));
    }

    public ClassInfo getEjbClass() {
        ClassInfo ejbClass = this.getCmp11Class();
        if (ejbClass == null) {
            ejbClass = this.getSrcClass();
        }
        return ejbClass;
    }

    public static String shortName(String fullName) {
        if (fullName == null) {
            return null;
        }
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot != -1) {
            return fullName.substring(lastDot + 1);
        }
        return fullName;
    }
}

