/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.ejb;

import vdoclet.beaninfo.PropertyInfo;
import vdoclet.docinfo.FieldInfo;
import vdoclet.docinfo.MethodInfo;
import vdoclet.ejb.EjbInfo;

public class EjbRelationRole {
    private EjbInfo _ejb;
    private FieldInfo _cmrField;
    private EjbRelationRole _target;

    public EjbRelationRole(EjbInfo ejb) {
        this._ejb = ejb;
    }

    public EjbRelationRole(EjbInfo ejb, FieldInfo cmrField) {
        this(ejb);
        this.setField(cmrField);
    }

    public EjbInfo getEjb() {
        return this._ejb;
    }

    public String getName() {
        String roleName = this.getEjb().getName();
        if (this.getField() != null) {
            roleName = roleName + '.' + this.getField().getName();
        }
        return roleName;
    }

    public void setField(FieldInfo cmrField) {
        this._cmrField = cmrField;
    }

    public void setField(MethodInfo cmrMethod) {
        this.setField(PropertyInfo.fromGetter(cmrMethod));
    }

    FieldInfo getField() {
        return this._cmrField;
    }

    public String getFieldName() {
        return this._cmrField == null ? null : this._cmrField.getName();
    }

    public String getFieldType() {
        if (this.getField() == null) {
            return null;
        }
        String type = this.getField().getType();
        if (type.equals("java.util.Collection") || type.equals("java.util.Set")) {
            return type;
        }
        return null;
    }

    public String getTagValue(String name, String defaultValue) {
        if (this.getField() == null) {
            return null;
        }
        return this.getField().getTagValue(name, defaultValue);
    }

    public String getTagValue(String name) {
        return this.getTagValue(name, null);
    }

    public EjbRelationRole getTarget() {
        return this._target;
    }

    public void setTarget(EjbRelationRole target) {
        this._target = target;
    }

    public Multiplicity getMultiplicity() {
        String explicitMultiplicity = this.getTagValue("@ejb-cmr-target-multiplicity");
        if (explicitMultiplicity != null) {
            return Multiplicity.forName(explicitMultiplicity);
        }
        if (this.getTarget() != null && this.getTarget().getFieldType() != null) {
            return Multiplicity.MANY;
        }
        return Multiplicity.ONE;
    }

    public static class Multiplicity {
        public static final Multiplicity ONE = new Multiplicity("One");
        public static final Multiplicity MANY = new Multiplicity("Many");
        private final String _name;

        private Multiplicity(String name) {
            this._name = name;
        }

        public static Multiplicity forName(String name) {
            return name.toLowerCase().equals("many") ? MANY : ONE;
        }

        public String toString() {
            return this._name;
        }
    }
}

