/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.ejb;

import java.util.Iterator;
import vdoclet.docinfo.BaseElementInfo;
import vdoclet.docinfo.ClassInfo;
import vdoclet.docinfo.MethodInfo;
import vdoclet.ejb.EjbInfo;
import vdoclet.ejb.RegisteredClassInfo;
import vdoclet.util.StringUtils;

public abstract class EjbView {
    private EjbInfo _ejbInfo;

    public EjbView(EjbInfo ejbInfo) {
        this._ejbInfo = ejbInfo;
    }

    EjbInfo getEjb() {
        return this._ejbInfo;
    }

    abstract String getViewSuffix();

    abstract String getFlagTag();

    abstract String getInterfaceClassTag();

    abstract String getInterfaceExtendsTag();

    abstract String getHomeClassTag();

    abstract String getHomeJndiTag();

    abstract String getDefaultSuperInterface();

    abstract EjbView getSuperView(EjbInfo var1);

    void addViewExceptions(MethodInfo viewMethod) {
    }

    public boolean isFlagged(BaseElementInfo element) {
        return element.getTagValue(this.getFlagTag()) != null;
    }

    public String getInterfaceClassName() {
        return this.getEjb().getTagValue(this.getInterfaceClassTag(), this.getEjb().getBaseName() + this.getViewSuffix());
    }

    MethodInfo makeInterfaceMethod(MethodInfo method) {
        MethodInfo interfaceMethod = (MethodInfo)method.clone();
        this.addViewExceptions(interfaceMethod);
        return interfaceMethod;
    }

    String getSuperInterface() {
        String explicitValue = this.getEjb().getTagValue(this.getInterfaceExtendsTag());
        if (explicitValue != null) {
            return explicitValue;
        }
        EjbInfo superEjb = this.getEjb().getSuperEjb();
        if (superEjb != null) {
            return this.getSuperView(superEjb).getInterface().getName();
        }
        return this.getDefaultSuperInterface();
    }

    public ClassInfo getInterface() {
        String ifaceName = this.getInterfaceClassName();
        ClassInfo iface = new ClassInfo(ifaceName);
        Iterator iter = this.getEjb().getSrcClass().getMethods().iterator();
        while (iter.hasNext()) {
            MethodInfo method = (MethodInfo)iter.next();
            if (!this.isFlagged(method) || method.getName().startsWith("ejb")) continue;
            iface.addMethod(this.makeInterfaceMethod(method));
        }
        iface.addInterface(this.getSuperInterface());
        return iface;
    }

    String getHomeClassName() {
        return this.getEjb().getTagValue(this.getHomeClassTag(), this.getInterfaceClassName() + "Home");
    }

    String getHomeJndiName() {
        return this.getEjb().getTagValue(this.getHomeJndiTag(), this.getHomeClassName());
    }

    public RegisteredClassInfo getHome() {
        RegisteredClassInfo home = new RegisteredClassInfo(this.getHomeClassName(), this.getHomeJndiName());
        Iterator i = this.getEjb().getAllSrcMethods().iterator();
        while (i.hasNext()) {
            MethodInfo method = (MethodInfo)i.next();
            if (!this.isFlagged(method)) continue;
            if (method.getName().startsWith("ejbCreate")) {
                home.addMethod(this.makeCreateMethod(method));
                continue;
            }
            if (method.getName().startsWith("ejbFind")) {
                home.addMethod(this.makeFinderMethod(method));
                continue;
            }
            if (!method.getName().startsWith("ejbHome")) continue;
            home.addMethod(this.makeHomeMethod(method));
        }
        return home;
    }

    MethodInfo makeCreateMethod(MethodInfo ejbCreate) {
        MethodInfo create = (MethodInfo)ejbCreate.clone();
        create.setName(StringUtils.stripPrefix("ejb", ejbCreate.getName()));
        this.addViewExceptions(create);
        create.setType(this.getInterfaceClassName());
        return create;
    }

    MethodInfo makeFinderMethod(MethodInfo ejbFinder) {
        MethodInfo finder = (MethodInfo)ejbFinder.clone();
        finder.setName(StringUtils.stripPrefix("ejb", ejbFinder.getName()));
        this.addViewExceptions(finder);
        if (finder.getType().equals(this.getEjb().getPrimaryKeyClassName())) {
            finder.setType(this.getInterfaceClassName());
        }
        return finder;
    }

    MethodInfo makeHomeMethod(MethodInfo ejbHomeMethod) {
        MethodInfo homeMethod = (MethodInfo)ejbHomeMethod.clone();
        homeMethod.setName(StringUtils.stripPrefix("ejbHome", ejbHomeMethod.getName()));
        this.addViewExceptions(homeMethod);
        return homeMethod;
    }
}

