/*
 * Decompiled with CFR 0.152.
 */
package vdoclet.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class DelimitedCollection
extends AbstractCollection {
    private String delimiter;
    private Collection collection;

    public DelimitedCollection(Collection collection, String delimiter) {
        this.collection = collection;
        this.delimiter = delimiter;
    }

    public int size() {
        return this.collection.size();
    }

    public Iterator iterator() {
        return this.collection.iterator();
    }

    public String toString() {
        return DelimitedCollection.join(this.collection, this.delimiter);
    }

    public static String join(Collection c, String delimiter) {
        if (c.isEmpty()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        Iterator i = c.iterator();
        buff.append(DelimitedCollection.toString(i.next()));
        while (i.hasNext()) {
            buff.append(delimiter);
            buff.append(DelimitedCollection.toString(i.next()));
        }
        return buff.toString();
    }

    private static String toString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }
}

