/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import jdepend.framework.ClassFileParser;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;
import junit.textui.TestRunner;

public class ClassFileParserTest
extends JDependTestCase {
    private ClassFileParser parser;
    private String baseClassDir;
    static /* synthetic */ Class class$jdepend$framework$ClassFileParserTest;

    public ClassFileParserTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        PackageFilter filter = new PackageFilter(new ArrayList());
        this.parser = new ClassFileParser(filter);
        this.baseClassDir = this.getClassesDir() + "jdepend" + File.separator + "framework" + File.separator;
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testParseInvalidClassFile() {
        File f = new File(this.getSrcDir() + "jdepend" + File.separator + "framework" + File.separator + "JDepend.java");
        try {
            this.parser.parse(f);
            ClassFileParserTest.fail((String)"Invalid class file: Should raise IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testParseInterfaceClass() throws IOException {
        JavaClass clazz = this.parser.parse(new File(this.baseClassDir + "MockInterface.class"));
        ClassFileParserTest.assertTrue((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.MockInterface", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"MockInterface.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)6, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.math")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.text")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.io")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.rmi")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util")));
    }

    public void testParseAbstractClass() throws IOException {
        JavaClass clazz = this.parser.parse(new File(this.baseClassDir + "MockAbstractClass.class"));
        ClassFileParserTest.assertTrue((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.MockAbstractClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"MockAbstractClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)7, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.math")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.text")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang.reflect")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.io")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.rmi")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util")));
    }

    public void testParseConcreteClass() throws IOException {
        JavaClass clazz = this.parser.parse(new File(this.baseClassDir + "MockConcreteClass.class"));
        ClassFileParserTest.assertFalse((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.MockConcreteClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"MockConcreteClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)9, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.net")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.text")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.sql")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.io")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.rmi")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util.jar")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.math")));
    }

    public void testParseInnerClass() throws IOException {
        JavaClass clazz = this.parser.parse(new File(this.baseClassDir + "MockConcreteClass$MockInnerClass.class"));
        ClassFileParserTest.assertFalse((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.MockConcreteClass$MockInnerClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"MockConcreteClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)1, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
    }

    public void testParsePackageClass() throws IOException {
        JavaClass clazz = this.parser.parse(new File(this.baseClassDir + "MockPackageClass.class"));
        ClassFileParserTest.assertFalse((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.MockPackageClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"MockConcreteClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)1, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$ClassFileParserTest == null ? (class$jdepend$framework$ClassFileParserTest = ClassFileParserTest.class$("jdepend.framework.ClassFileParserTest")) : class$jdepend$framework$ClassFileParserTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

