/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.util.ArrayList;
import java.util.List;
import jdepend.framework.JavaPackage;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CollectAllCyclesTest
extends TestCase {
    static /* synthetic */ Class class$jdepend$framework$CollectAllCyclesTest;

    public CollectAllCyclesTest(String name) {
        super(name);
    }

    public void testNoCycles() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        a.dependsUpon(b);
        ArrayList aCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)false, (boolean)a.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)false, (boolean)a.collectAllCycles(aCycles));
        this.assertListEquals(aCycles, new String[0]);
        ArrayList bCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)false, (boolean)b.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)false, (boolean)b.collectAllCycles(bCycles));
        this.assertListEquals(bCycles, new String[0]);
    }

    public void test2Node1BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        a.dependsUpon(b);
        b.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.collectAllCycles(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "A"});
        ArrayList bCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.collectAllCycles(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "A", "B"});
    }

    public void test3Node1BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        a.dependsUpon(b);
        b.dependsUpon(c);
        c.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.collectAllCycles(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "C", "A"});
        ArrayList bCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.collectAllCycles(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "C", "A", "B"});
        ArrayList cCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.collectAllCycles(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "A", "B", "C"});
    }

    public void test3Node1BranchSubCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        a.dependsUpon(b);
        b.dependsUpon(c);
        c.dependsUpon(b);
        ArrayList aCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.collectAllCycles(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "C", "B"});
        ArrayList bCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.collectAllCycles(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "C", "B"});
        ArrayList cCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.collectAllCycles(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "B", "C"});
    }

    public void test3Node2BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        a.dependsUpon(b);
        b.dependsUpon(a);
        a.dependsUpon(c);
        c.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.collectAllCycles(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "A", "C", "A"});
        ArrayList bCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.collectAllCycles(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "A", "B", "C", "A"});
        ArrayList cCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.collectAllCycles(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "A", "B", "A", "C"});
    }

    public void test5Node2BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        JavaPackage d = new JavaPackage("D");
        JavaPackage e = new JavaPackage("E");
        a.dependsUpon(b);
        b.dependsUpon(c);
        c.dependsUpon(a);
        a.dependsUpon(d);
        d.dependsUpon(e);
        e.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)a.collectAllCycles(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "C", "A", "D", "E", "A"});
        ArrayList bCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)b.collectAllCycles(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "C", "A", "B", "D", "E", "A"});
        ArrayList cCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)c.collectAllCycles(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "A", "B", "C", "D", "E", "A"});
        ArrayList dCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)d.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)d.collectAllCycles(dCycles));
        this.assertListEquals(dCycles, new String[]{"D", "E", "A", "B", "C", "A", "D"});
        ArrayList eCycles = new ArrayList();
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)e.containsCycle());
        CollectAllCyclesTest.assertEquals((boolean)true, (boolean)e.collectAllCycles(eCycles));
        this.assertListEquals(eCycles, new String[]{"E", "A", "B", "C", "A", "D", "E"});
    }

    protected void assertListEquals(List list, String[] names) {
        CollectAllCyclesTest.assertEquals((int)names.length, (int)list.size());
        for (int i = 0; i < names.length; ++i) {
            CollectAllCyclesTest.assertEquals((String)names[i], (String)((JavaPackage)list.get(i)).getName());
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$CollectAllCyclesTest == null ? (class$jdepend$framework$CollectAllCyclesTest = CollectAllCyclesTest.class$("jdepend.framework.CollectAllCyclesTest")) : class$jdepend$framework$CollectAllCyclesTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

