/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import jdepend.framework.DependencyConstraint;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ConstraintTest
extends TestCase {
    private JDepend jdepend;
    private String BASE_DIR;
    static /* synthetic */ Class class$jdepend$framework$ConstraintTest;

    public ConstraintTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.BASE_DIR = System.getProperty("jdepend.home");
        if (this.BASE_DIR == null) {
            ConstraintTest.fail((String)"Property 'jdepend.home' not defined");
        }
        PackageFilter filter = new PackageFilter();
        filter.addPackage("java.*");
        filter.addPackage("javax.*");
        this.jdepend = new JDepend(filter);
    }

    protected void tearDown() {
        this.jdepend = null;
    }

    public void testConstraintPass() {
        DependencyConstraint constraint = new DependencyConstraint();
        JavaPackage expectedA = constraint.addPackage("A");
        JavaPackage expectedB = constraint.addPackage("B");
        expectedA.dependsUpon(expectedB);
        JavaPackage actualA = new JavaPackage("A");
        JavaPackage actualB = new JavaPackage("B");
        actualA.dependsUpon(actualB);
        this.jdepend.addPackage(actualA);
        this.jdepend.addPackage(actualB);
        ConstraintTest.assertEquals((boolean)true, (boolean)this.jdepend.dependencyMatch(constraint));
    }

    public void testConstraintFail() {
        DependencyConstraint constraint = new DependencyConstraint();
        JavaPackage expectedA = constraint.addPackage("A");
        JavaPackage expectedB = constraint.addPackage("B");
        JavaPackage expectedC = constraint.addPackage("C");
        expectedA.dependsUpon(expectedB);
        JavaPackage actualA = new JavaPackage("A");
        JavaPackage actualB = new JavaPackage("B");
        JavaPackage actualC = new JavaPackage("C");
        actualA.dependsUpon(actualB);
        actualA.dependsUpon(actualC);
        this.jdepend.addPackage(actualA);
        this.jdepend.addPackage(actualB);
        this.jdepend.addPackage(actualC);
        ConstraintTest.assertEquals((boolean)false, (boolean)this.jdepend.dependencyMatch(constraint));
    }

    public void testAnalyzedConstraint() throws IOException {
        String filename = this.BASE_DIR + File.separator + "build";
        this.jdepend.addDirectory(filename);
        this.jdepend.analyze();
        DependencyConstraint constraint = new DependencyConstraint();
        JavaPackage junitframework = constraint.addPackage("junit.framework");
        JavaPackage junitui = constraint.addPackage("junit.textui");
        JavaPackage framework = constraint.addPackage("jdepend.framework");
        JavaPackage text = constraint.addPackage("jdepend.textui");
        JavaPackage xml = constraint.addPackage("jdepend.xmlui");
        JavaPackage swing = constraint.addPackage("jdepend.swingui");
        framework.dependsUpon(junitframework);
        framework.dependsUpon(junitui);
        text.dependsUpon(framework);
        xml.dependsUpon(text);
        swing.dependsUpon(framework);
        ConstraintTest.assertEquals((boolean)true, (boolean)this.jdepend.dependencyMatch(constraint));
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$ConstraintTest == null ? (class$jdepend$framework$ConstraintTest = ConstraintTest.class$("jdepend.framework.ConstraintTest")) : class$jdepend$framework$ConstraintTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

