/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdepend.framework.JavaPackage;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CycleTest
extends TestCase {
    static /* synthetic */ Class class$jdepend$framework$CycleTest;

    public CycleTest(String name) {
        super(name);
    }

    public void testNoCycles() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        a.dependsUpon(b);
        ArrayList aCycles = new ArrayList();
        CycleTest.assertEquals((boolean)false, (boolean)a.containsCycle());
        CycleTest.assertEquals((boolean)false, (boolean)a.collectCycle(aCycles));
        this.assertListEquals(aCycles, new String[0]);
        ArrayList bCycles = new ArrayList();
        CycleTest.assertEquals((boolean)false, (boolean)b.containsCycle());
        CycleTest.assertEquals((boolean)false, (boolean)b.collectCycle(bCycles));
        this.assertListEquals(bCycles, new String[0]);
    }

    public void test2Node1BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        a.dependsUpon(b);
        b.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)a.collectCycle(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "A"});
        ArrayList bCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)b.collectCycle(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "A", "B"});
    }

    public void test3Node1BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        a.dependsUpon(b);
        b.dependsUpon(c);
        c.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)a.collectCycle(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "C", "A"});
        ArrayList bCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)b.collectCycle(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "C", "A", "B"});
        ArrayList cCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)c.collectCycle(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "A", "B", "C"});
    }

    public void test3Node1BranchSubCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        a.dependsUpon(b);
        b.dependsUpon(c);
        c.dependsUpon(b);
        ArrayList aCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)a.collectCycle(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "C", "B"});
        ArrayList bCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)b.collectCycle(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "C", "B"});
        ArrayList cCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)c.collectCycle(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "B", "C"});
    }

    public void test3Node2BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        a.dependsUpon(b);
        b.dependsUpon(a);
        a.dependsUpon(c);
        c.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)a.collectCycle(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "A"});
        ArrayList bCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)b.collectCycle(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "A", "B"});
        ArrayList cCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)c.collectCycle(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "A", "B", "A"});
    }

    public void test5Node2BranchCycle() {
        JavaPackage a = new JavaPackage("A");
        JavaPackage b = new JavaPackage("B");
        JavaPackage c = new JavaPackage("C");
        JavaPackage d = new JavaPackage("D");
        JavaPackage e = new JavaPackage("E");
        a.dependsUpon(b);
        b.dependsUpon(c);
        c.dependsUpon(a);
        a.dependsUpon(d);
        d.dependsUpon(e);
        e.dependsUpon(a);
        ArrayList aCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)a.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)a.collectCycle(aCycles));
        this.assertListEquals(aCycles, new String[]{"A", "B", "C", "A"});
        ArrayList bCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)b.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)b.collectCycle(bCycles));
        this.assertListEquals(bCycles, new String[]{"B", "C", "A", "B"});
        ArrayList cCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)c.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)c.collectCycle(cCycles));
        this.assertListEquals(cCycles, new String[]{"C", "A", "B", "C"});
        ArrayList dCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)d.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)d.collectCycle(dCycles));
        this.assertListEquals(dCycles, new String[]{"D", "E", "A", "B", "C", "A"});
        ArrayList eCycles = new ArrayList();
        CycleTest.assertEquals((boolean)true, (boolean)e.containsCycle());
        CycleTest.assertEquals((boolean)true, (boolean)e.collectCycle(eCycles));
        this.assertListEquals(eCycles, new String[]{"E", "A", "B", "C", "A"});
    }

    protected void assertListEquals(List list, String[] names) {
        CycleTest.assertEquals((int)names.length, (int)list.size());
        for (int i = 0; i < names.length; ++i) {
            CycleTest.assertEquals((String)names[i], (String)((JavaPackage)list.get(i)).getName());
        }
    }

    protected void printCycles(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            JavaPackage p = (JavaPackage)i.next();
            if (i.hasNext()) {
                System.out.print(p.getName() + "->");
                continue;
            }
            System.out.println(p.getName());
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$CycleTest == null ? (class$jdepend$framework$CycleTest = CycleTest.class$("jdepend.framework.CycleTest")) : class$jdepend$framework$CycleTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

