/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import jdepend.framework.JavaPackage;

public class DependencyConstraint {
    private HashMap packages = new HashMap();

    public JavaPackage addPackage(String packageName) {
        JavaPackage jPackage = (JavaPackage)this.packages.get(packageName);
        if (jPackage == null) {
            jPackage = new JavaPackage(packageName);
            this.addPackage(jPackage);
        }
        return jPackage;
    }

    public void addPackage(JavaPackage jPackage) {
        if (!this.packages.containsValue(jPackage)) {
            this.packages.put(jPackage.getName(), jPackage);
        }
    }

    public Collection getPackages() {
        return this.packages.values();
    }

    public boolean match(Collection expectedPackages) {
        Object next;
        Iterator packageIter;
        if (this.packages.size() == expectedPackages.size() && (packageIter = expectedPackages.iterator()).hasNext() && (next = packageIter.next()) instanceof JavaPackage) {
            JavaPackage nextPackage = (JavaPackage)next;
            return this.matchPackage(nextPackage);
        }
        return false;
    }

    private boolean matchPackage(JavaPackage expectedPackage) {
        JavaPackage actualPackage = (JavaPackage)this.packages.get(expectedPackage.getName());
        return actualPackage != null && this.equalsDependencies(actualPackage, expectedPackage);
    }

    private boolean equalsDependencies(JavaPackage a, JavaPackage b) {
        return this.equalsAfferents(a, b) && this.equalsEfferents(a, b);
    }

    private boolean equalsAfferents(JavaPackage a, JavaPackage b) {
        if (a.equals(b)) {
            Collection otherAfferents = b.getAfferents();
            if (a.getAfferents().size() == otherAfferents.size()) {
                Iterator afferentIter = a.getAfferents().iterator();
                while (afferentIter.hasNext()) {
                    JavaPackage afferent = (JavaPackage)afferentIter.next();
                    if (otherAfferents.contains(afferent)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean equalsEfferents(JavaPackage a, JavaPackage b) {
        if (a.equals(b)) {
            Collection otherEfferents = b.getEfferents();
            if (a.getEfferents().size() == otherEfferents.size()) {
                Iterator efferentIter = a.getEfferents().iterator();
                while (efferentIter.hasNext()) {
                    JavaPackage efferent = (JavaPackage)efferentIter.next();
                    if (otherEfferents.contains(efferent)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

