/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import jdepend.framework.FileManager;
import jdepend.framework.JDependTestCase;
import junit.textui.TestRunner;

public class FileManagerTest
extends JDependTestCase {
    private FileManager fileManager;
    static /* synthetic */ Class class$jdepend$framework$FileManagerTest;

    public FileManagerTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.fileManager = new FileManager();
        this.fileManager.acceptInnerClasses(false);
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testEmptyFileManager() {
        FileManagerTest.assertEquals((int)0, (int)this.fileManager.extractFiles().size());
    }

    public void testAddClassesDirectory() throws IOException {
        this.fileManager.addDirectory(this.getClassesDir());
        FileManagerTest.assertEquals((int)38, (int)this.fileManager.extractFiles().size());
    }

    public void testAddNonExistentDirectory() {
        try {
            this.fileManager.addDirectory(this.getSrcDir() + "junk");
            FileManagerTest.fail((String)"Non-existent directory: Should raise IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testAddInvalidDirectory() {
        try {
            this.fileManager.addDirectory(this.getSrcDir() + "JDepend.java");
            FileManagerTest.fail((String)"Invalid directory: Should raise IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testClassFileAccept() throws IOException {
        File f = new File(this.getClassesDir() + "jdepend" + File.separator + "framework" + File.separator + "JDepend.class");
        FileManagerTest.assertEquals((boolean)true, (boolean)new FileManager().acceptClassFile(f));
    }

    public void testAcceptNonExistentClassFile() {
        File f = new File(this.getClassesDir() + "JDepend.class");
        FileManagerTest.assertEquals((boolean)false, (boolean)new FileManager().acceptClassFile(f));
    }

    public void testAcceptInvalidClassFile() {
        String filename = this.getHomeDir() + "build.xml";
        File f = new File(filename);
        FileManagerTest.assertEquals((boolean)false, (boolean)new FileManager().acceptClassFile(f));
    }

    public void testAddValidJar() throws IOException {
        File f = File.createTempFile("bogus", ".jar", new File(this.getLibDir()));
        this.fileManager.addDirectory(f.getPath());
        f.deleteOnExit();
    }

    public void testAddValidZip() throws IOException {
        File f = File.createTempFile("bogus", ".zip", new File(this.getLibDir()));
        this.fileManager.addDirectory(f.getPath());
        f.deleteOnExit();
    }

    public void testAddValidWar() throws IOException {
        File f = File.createTempFile("bogus", ".war", new File(this.getLibDir()));
        this.fileManager.addDirectory(f.getPath());
        f.deleteOnExit();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$FileManagerTest == null ? (class$jdepend$framework$FileManagerTest = FileManagerTest.class$("jdepend.framework.FileManagerTest")) : class$jdepend$framework$FileManagerTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

