/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import jdepend.framework.FileManager;
import jdepend.framework.JDepend;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaClassBuilder;
import junit.textui.TestRunner;

public class JarFileParserTest
extends JDependTestCase {
    private File jarFile;
    private File zipFile;
    static /* synthetic */ Class class$jdepend$framework$JarFileParserTest;

    public JarFileParserTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.jarFile = new File(this.getTestDataDir() + "test.jar");
        this.zipFile = new File(this.getTestDataDir() + "test.zip");
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testParseInvalidJarFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        File bogusFile = new File(this.getTestDataDir() + "bogus.jar");
        try {
            builder.buildClasses(bogusFile);
            JarFileParserTest.fail((String)"Should raise IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testParseInvalidZipFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        File bogusFile = new File(this.getTestDataDir() + "bogus.zip");
        try {
            builder.buildClasses(bogusFile);
            JarFileParserTest.fail((String)"Should raise IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testParseJarFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        Collection classes = builder.buildClasses(this.jarFile);
        JarFileParserTest.assertEquals((int)4, (int)classes.size());
        this.assertClassesExist(classes);
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.MockConcreteClass$MockInnerClass")));
    }

    public void testParseJarFileWithoutInnerClasses() throws IOException {
        FileManager fm = new FileManager();
        fm.acceptInnerClasses(false);
        JavaClassBuilder builder = new JavaClassBuilder(fm);
        Collection classes = builder.buildClasses(this.jarFile);
        JarFileParserTest.assertEquals((int)3, (int)classes.size());
        this.assertClassesExist(classes);
    }

    public void testParseZipFile() throws IOException {
        JavaClassBuilder builder = new JavaClassBuilder();
        Collection classes = builder.buildClasses(this.zipFile);
        JarFileParserTest.assertEquals((int)4, (int)classes.size());
        this.assertClassesExist(classes);
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.MockConcreteClass$MockInnerClass")));
    }

    public void testParseZipFileWithoutInnerClasses() throws IOException {
        FileManager fm = new FileManager();
        fm.acceptInnerClasses(false);
        JavaClassBuilder builder = new JavaClassBuilder(fm);
        Collection classes = builder.buildClasses(this.zipFile);
        JarFileParserTest.assertEquals((int)3, (int)classes.size());
        this.assertClassesExist(classes);
    }

    private void assertClassesExist(Collection classes) {
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.MockAbstractClass")));
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.MockInterface")));
        JarFileParserTest.assertTrue((boolean)classes.contains(new JavaClass("jdepend.framework.MockConcreteClass")));
    }

    public void testCountClasses() throws IOException {
        JDepend jdepend = new JDepend();
        jdepend.addDirectory(this.getTestDataDir());
        jdepend.analyzeInnerClasses(true);
        JarFileParserTest.assertEquals((int)8, (int)jdepend.countClasses());
        jdepend.analyzeInnerClasses(false);
        JarFileParserTest.assertEquals((int)6, (int)jdepend.countClasses());
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$JarFileParserTest == null ? (class$jdepend$framework$JarFileParserTest = JarFileParserTest.class$("jdepend.framework.JarFileParserTest")) : class$jdepend$framework$JarFileParserTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

