/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import jdepend.framework.AbstractParser;
import jdepend.framework.ClassFileParser;
import jdepend.framework.FileManager;
import jdepend.framework.JavaClass;

public class JavaClassBuilder {
    private AbstractParser parser;
    private FileManager fileManager;

    public JavaClassBuilder() {
        this(new ClassFileParser(), new FileManager());
    }

    public JavaClassBuilder(FileManager fm) {
        this(new ClassFileParser(), fm);
    }

    public JavaClassBuilder(AbstractParser parser, FileManager fm) {
        this.parser = parser;
        this.fileManager = fm;
    }

    public int countClasses() {
        AbstractParser counter = new AbstractParser(){

            public JavaClass parse(InputStream is) {
                return new JavaClass("");
            }
        };
        JavaClassBuilder builder = new JavaClassBuilder(counter, this.fileManager);
        Collection classes = builder.build();
        return classes.size();
    }

    public Collection build() {
        ArrayList classes = new ArrayList();
        Iterator fileIter = this.fileManager.extractFiles().iterator();
        while (fileIter.hasNext()) {
            File nextFile = (File)fileIter.next();
            try {
                classes.addAll(this.buildClasses(nextFile));
            }
            catch (IOException ioe) {
                System.err.println("\n" + ioe.getMessage());
            }
        }
        return classes;
    }

    public Collection buildClasses(File file) throws IOException {
        if (this.fileManager.acceptClassFile(file)) {
            JavaClass parsedClass = this.parser.parse(new FileInputStream(file));
            ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>();
            javaClasses.add(parsedClass);
            return javaClasses;
        }
        if (this.fileManager.acceptJarFile(file)) {
            JarFile jarFile = new JarFile(file);
            return this.buildClasses(jarFile);
        }
        throw new IOException("File is not a valid .class, .jar, or .zip file: " + file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection buildClasses(JarFile file) throws IOException {
        ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>();
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry e = entries.nextElement();
            if (!this.fileManager.acceptClassFileName(e.getName())) continue;
            InputStream is = null;
            try {
                is = file.getInputStream(e);
                JavaClass jc = this.parser.parse(is);
                javaClasses.add(jc);
            }
            finally {
                is.close();
            }
        }
        return javaClasses;
    }
}

