/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.IOException;
import java.text.NumberFormat;
import jdepend.framework.JDepend;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;
import junit.textui.TestRunner;

public class MetricTest
extends JDependTestCase {
    private JDepend jdepend;
    private static NumberFormat formatter = NumberFormat.getInstance();
    static /* synthetic */ Class class$jdepend$framework$MetricTest;

    public MetricTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        PackageFilter filter = new PackageFilter();
        filter.addPackage("java.*");
        filter.addPackage("javax.*");
        this.jdepend = new JDepend(filter);
        this.jdepend.analyzeInnerClasses(false);
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testAnalyzeClassFiles() throws IOException {
        this.jdepend.addDirectory(this.getClassesDir());
        this.assertAnalyzePackages();
    }

    private void assertAnalyzePackages() {
        MetricTest.assertEquals((int)38, (int)this.jdepend.countClasses());
        PackageFilter filter = this.jdepend.getFilter();
        filter.addPackage("junit.*");
        this.jdepend.analyze();
        this.assertFrameworkPackage();
        this.assertTextUIPackage();
        this.assertSwingUIPackage();
    }

    private void assertFrameworkPackage() {
        JavaPackage p = this.jdepend.getPackage("jdepend.framework");
        MetricTest.assertNotNull((Object)p);
        MetricTest.assertEquals((int)24, (int)p.getConcreteClassCount());
        MetricTest.assertEquals((int)4, (int)p.getAbstractClassCount());
        MetricTest.assertEquals((int)3, (int)p.afferentCoupling());
        MetricTest.assertEquals((int)0, (int)p.efferentCoupling());
        MetricTest.assertEquals((String)this.format(0.14f), (String)this.format(p.abstractness()));
        MetricTest.assertEquals((String)this.format(0.0f), (String)this.format(p.instability()));
        MetricTest.assertEquals((String)this.format(0.86f), (String)this.format(p.distance()));
        MetricTest.assertEquals((int)1, (int)p.getVolatility());
    }

    private void assertTextUIPackage() {
        JavaPackage p = this.jdepend.getPackage("jdepend.textui");
        MetricTest.assertNotNull((Object)p);
        MetricTest.assertEquals((int)1, (int)p.getConcreteClassCount());
        MetricTest.assertEquals((int)0, (int)p.getAbstractClassCount());
        MetricTest.assertEquals((int)1, (int)p.efferentCoupling());
        MetricTest.assertEquals((String)"0", (String)this.format(p.abstractness()));
        MetricTest.assertEquals((int)1, (int)p.afferentCoupling());
        MetricTest.assertEquals((String)this.format(0.5f), (String)this.format(p.instability()));
        MetricTest.assertEquals((String)this.format(0.5f), (String)this.format(p.distance()));
        MetricTest.assertEquals((int)1, (int)p.getVolatility());
    }

    private void assertSwingUIPackage() {
        JavaPackage p = this.jdepend.getPackage("jdepend.swingui");
        MetricTest.assertNotNull((Object)p);
        MetricTest.assertEquals((int)7, (int)p.getConcreteClassCount());
        MetricTest.assertEquals((int)1, (int)p.getAbstractClassCount());
        MetricTest.assertEquals((int)0, (int)p.afferentCoupling());
        MetricTest.assertEquals((int)1, (int)p.efferentCoupling());
        MetricTest.assertEquals((String)this.format(0.12f), (String)this.format(p.abstractness()));
        MetricTest.assertEquals((String)"1", (String)this.format(p.instability()));
        MetricTest.assertEquals((String)this.format(0.12f), (String)this.format(p.distance()));
        MetricTest.assertEquals((int)1, (int)p.getVolatility());
    }

    public void testConfiguredVolatility() throws IOException {
        this.jdepend.addDirectory(this.getClassesDir());
        JavaPackage pkg = new JavaPackage("jdepend.swingui");
        pkg.setVolatility(0);
        this.jdepend.addPackage(pkg);
        this.jdepend.analyze();
        JavaPackage analyzedPkg = this.jdepend.getPackage(pkg.getName());
        MetricTest.assertEquals((int)0, (int)analyzedPkg.getVolatility());
        MetricTest.assertEquals((String)this.format(0.0f), (String)this.format(analyzedPkg.distance()));
        MetricTest.assertEquals((int)7, (int)analyzedPkg.getConcreteClassCount());
    }

    private String format(float f) {
        return formatter.format(f);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$MetricTest == null ? (class$jdepend$framework$MetricTest = MetricTest.class$("jdepend.framework.MetricTest")) : class$jdepend$framework$MetricTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        formatter.setMaximumFractionDigits(2);
    }
}

