/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.hibernate;

import java.text.MessageFormat;
import org.apache.tools.ant.types.EnumeratedAttribute;
import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.util.Translator;
import xjavadoc.XClass;

public class HibernateSubTask
extends XmlSubTask {
    public static final String DEFAULT_HIBERNATE_CLASS_PATTERN = "{0}";
    private static final String HIBERNATE_PUBLICID_11 = "-//Hibernate/Hibernate Mapping DTD 1.1//EN";
    private static final String HIBERNATE_SYSTEMID_11 = "http://hibernate.sourceforge.net/hibernate-mapping-1.1.dtd";
    private static final String DTD_FILE_NAME_11 = "resources/hibernate-mapping_1_1.dtd";
    private static final String HIBERNATE_PUBLICID_20 = "-//Hibernate/Hibernate Mapping DTD 2.0//EN";
    private static final String HIBERNATE_SYSTEMID_20 = "http://hibernate.sourceforge.net/hibernate-mapping-2.0.dtd";
    private static final String DTD_FILE_NAME_20 = "resources/hibernate-mapping_2_0.dtd";
    private static String DEFAULT_HIBERNATE_TEMPLATE_FILE = "resources/hibernate.xdt";
    private static String GENERATED_HIBERNATE_FILE_NAME = "{0}.hbm.xml";
    private String hibernateVersion = "1.1";
    static /* synthetic */ Class class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages;

    public HibernateSubTask() {
        this.setHavingClassTag("hibernate.class");
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_HIBERNATE_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_HIBERNATE_FILE_NAME);
    }

    public String getGeneratedFileName(XClass clazz) throws XDocletException {
        return super.getGeneratedFileName(clazz);
    }

    public String getMappingURL(XClass clazz) {
        return MessageFormat.format(this.getDestinationFile(), clazz.getQualifiedName().replace('.', '/'), "");
    }

    public String getVersion() {
        return this.hibernateVersion;
    }

    public void setVersion(HibernateVersion version) {
        this.hibernateVersion = version.getValue();
    }

    public void execute() throws XDocletException {
        if (this.hibernateVersion.equals("1.1")) {
            this.setPublicId(HIBERNATE_PUBLICID_11);
            this.setSystemId(HIBERNATE_SYSTEMID_11);
            this.setDtdURL(((Object)((Object)this)).getClass().getResource(DTD_FILE_NAME_11));
        } else {
            this.setPublicId(HIBERNATE_PUBLICID_20);
            this.setSystemId(HIBERNATE_SYSTEMID_20);
            this.setDtdURL(((Object)((Object)this)).getClass().getResource(DTD_FILE_NAME_20));
        }
        this.startProcess();
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString((Class)(class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages == null ? (class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages = HibernateSubTask.class$("xdoclet.modules.hibernate.XDocletModulesHibernateMessages")) : class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages), (String)"GENERATING_HIBERNATE_FOR", (String[])new String[]{this.getCurrentClass().getQualifiedName()}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class HibernateVersion
    extends EnumeratedAttribute {
        public static final String HIBERNATE_1_1 = "1.1";
        public static final String HIBERNATE_2_0 = "2.0";

        public String[] getValues() {
            return new String[]{HIBERNATE_1_1, HIBERNATE_2_0};
        }
    }
}

