/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.model.document;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.model.commons.BaseVO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentInterface;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class DocumentList
extends BaseVO {
    private static final long serialVersionUID = 1L;
    protected static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$model$document$DocumentList == null ? (class$gov$epa$cdx$model$document$DocumentList = DocumentList.class$("gov.epa.cdx.model.document.DocumentList")) : class$gov$epa$cdx$model$document$DocumentList).getName());
    private TransactionVO transaction;
    private HashMap docs;
    private DataflowTypeVO dataflowType;
    static /* synthetic */ Class class$gov$epa$cdx$model$document$DocumentList;

    public DocumentList(DataflowTypeVO dataflowType) {
        this.docs = new HashMap();
        this.dataflowType = dataflowType;
    }

    public DocumentList(TransactionVO trans) {
        this.transaction = trans;
        this.docs = new HashMap();
    }

    public void addDocument(DocumentInterface document) throws CDXException {
        if (document.getName() == null) {
            log.error((Object)"The List Contains documents with no names. Can not store Documents with no names");
            throw new CDXValidationException(CDXErrorCode.DOCUMENT_NAME_INVALID);
        }
        this.docs.put(document.getName(), document);
    }

    public void addDocument(String documentName, String docType, String dataFlow, byte[] data) throws CDXException {
        DocumentList.validateName(documentName);
        DataflowTypeVO dataFlowType = DocumentList.validateDataFlowType(dataFlow);
        DocumentType documentType = DocumentList.validateDocumentType(docType);
        if (this.docs.containsKey(documentName)) {
            log.error((Object)"The List Contains documents with same names. Cannot store Documents with Non Unique names");
            throw new CDXValidationException(CDXErrorCode.DUPLICATE_DOCUMENT_NAMES);
        }
        DocumentVO documentVO = new DocumentVO(GUID.getGUID(), documentName, documentType, dataFlowType, data);
        this.docs.put(documentVO.getName(), documentVO);
    }

    public static DataflowTypeVO validateDataFlowType(String dataFlow) throws CDXException {
        DataflowTypeVO dataFlowType = new DataflowTypeVO(dataFlow);
        if (dataFlowType == null) {
            throw new CDXValidationException(CDXErrorCode.INVALID_DATA_FLOW_TYPE);
        }
        return dataFlowType;
    }

    public static DocumentType validateDocumentType(String type) throws CDXException {
        DocumentType documentType = DocumentType.getDocumentTypeById(type);
        if (documentType == null) {
            throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_TYPE);
        }
        return documentType;
    }

    public static void validateDocumentUniqueness() throws CDXException {
        throw new UnsupportedOperationException("Method validateDocumentUniqueness() not yet implemented.");
    }

    public static void validateName(String documentName) throws CDXException {
        documentName.trim();
        if (documentName == null || documentName.length() == 0) {
            log.error((Object)"Document Name is Not Specified");
            throw new CDXValidationException(CDXErrorCode.DOCUMENT_NAME_IS_NOT_SPECIFIED);
        }
    }

    public void validateDocumentSizes() throws CDXException {
        Iterator it = this.docs.values().iterator();
        while (it.hasNext()) {
            DocumentVO doc = (DocumentVO)it.next();
            if (doc.getData() != null && doc.getData().length != 0) continue;
            String error = "Document " + doc.getName() + " is 0 bytes in size.";
            log.error((Object)error);
            throw new CDXValidationException(CDXErrorCode.DOCUMENT_ZERO_BYTE_SIZE, (Throwable)new Exception(error));
        }
    }

    public void deleteDocuments() throws CDXException {
        throw new UnsupportedOperationException("Method DocumentList.deleteDocument() not implemented.");
    }

    public DocumentVO findDocument() {
        throw new UnsupportedOperationException("Method DocumentList.findDocument() not  implemented.");
    }

    public Collection getDocuments() {
        return this.docs.values();
    }

    public DocumentInterface getDocument(String name) {
        return (DocumentInterface)this.docs.get(name);
    }

    public TransactionVO getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionVO transaction) {
        this.transaction = transaction;
    }

    public void clearDocumentList() {
        this.docs.clear();
    }

    public DataflowTypeVO getDataflowTypeVO() {
        return this.dataflowType;
    }

    public void setDataFlowType(DataflowTypeVO dataFlowType) {
        this.dataflowType = dataFlowType;
        Iterator iter = this.getDocuments().iterator();
        while (iter.hasNext()) {
            DocumentVO documentVO = (DocumentVO)iter.next();
            documentVO.setDataFlowType(dataFlowType);
        }
    }

    public void deleteDocument(String name) {
        this.docs.remove(name);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.transaction != null) {
            buffer.append("Transaction: ");
            buffer.append(this.transaction.getTransactionID());
        }
        buffer.append("Dataflow: ");
        if (this.getDataflowTypeVO() != null && this.getDataflowTypeVO().getDataflowType() != null) {
            buffer.append(this.getDataflowTypeVO().getDataflowType().toString());
        } else {
            buffer.append("<NONE> ");
        }
        if (!this.docs.isEmpty()) {
            buffer.append(" Number of Documents: ");
            buffer.append(this.docs.size());
            buffer.append(". ");
            Iterator it = this.docs.values().iterator();
            while (it.hasNext()) {
                DocumentVO vo = (DocumentVO)it.next();
                if (vo == null) continue;
                buffer.append("Name: ");
                buffer.append(vo.getName());
                buffer.append(" Type: ");
                if (vo.getDocumentType() != null) {
                    buffer.append(vo.getDocumentType().toString());
                } else {
                    buffer.append("<NONE> ");
                }
                buffer.append(" Size: ");
                if (vo.getData() == null) continue;
                buffer.append(vo.getData().length);
                buffer.append(" bytes. ");
            }
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

