/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.model.document;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;

public class DocumentType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private static HashMap table = new HashMap();
    public static final DocumentType XML = new DocumentType("XML");
    public static final DocumentType BINARY = new DocumentType("BIN");
    public static final DocumentType FLAT = new DocumentType("FLAT");
    public static final DocumentType OTHER = new DocumentType("OTHER");
    public static final DocumentType ZIP = new DocumentType("ZIP");
    public static final DocumentType COMPLETED = new DocumentType("COMPLETED");
    public static final DocumentType PROCESSED = new DocumentType("PROCESSED");
    public static final DocumentType FAILED = new DocumentType("FAILED");
    public static final DocumentType PENDING = new DocumentType("PENDING");
    public static final DocumentType NOTIFY = new DocumentType("NOTIFY");
    public static final DocumentType HEADER = new DocumentType("HEADER");

    private DocumentType(String anID) {
        this.id = anID;
        table.put(anID, this);
    }

    public boolean equals(Object obj) {
        DocumentType otherDocType = (DocumentType)obj;
        return this.toString().equalsIgnoreCase(otherDocType.toString());
    }

    public static DocumentType getDocumentTypeById(String docTypeId) {
        return (DocumentType)table.get(docTypeId.toUpperCase());
    }

    public String toString() {
        return this.id;
    }

    private Object readResolve() throws ObjectStreamException {
        return DocumentType.getDocumentTypeById(this.id);
    }
}

